/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.HashSet;
import java.util.Iterator;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import xyz.pixelatedw.mineminenomi.abilities.suna.GroundDeathAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.DesertGirasole2ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.DesertGirasoleParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.BlockPlacingHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class DesertGirasoleAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new DesertGirasoleAbility();
    BlockPlacingHelper blockPlacingHelper = new BlockPlacingHelper();
    private static final ParticleEffect PARTICLES1 = new DesertGirasoleParticleEffect();
    private static final ParticleEffect PARTICLES2 = new DesertGirasole2ParticleEffect();

    public DesertGirasoleAbility() {
        super("Desert Girasole", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(30.0);
        this.setMaxChargeTime(5.0);
        this.setDescription("A giant pit of quicksand will be formed with the sand being taken away by underground rivers \n\nThis can only be used on sand!");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        GroundDeathAbility ability = (GroundDeathAbility)AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(GroundDeathAbility.INSTANCE);
        int range = DesertGirasoleAbility.isFruitBoosted(player) ? 24 : 12;
        for (int i = -range; i < range; ++i) {
            for (int j = -8; j < 8; ++j) {
                for (int k = -range; k < range; ++k) {
                    double posZ;
                    double posY;
                    double posX = player.func_226277_ct_() + (double)i + ((double)i < -WyHelper.randomWithRange(8, 12) || (double)i > WyHelper.randomWithRange(8, 12) ? WyHelper.randomWithRange(-5, 5) : 0.0);
                    if (!player.field_70170_p.func_180495_p(new BlockPos(posX, posY = player.func_226278_cu_() + (double)j, posZ = player.func_226281_cx_() + (double)k + ((double)k < -WyHelper.randomWithRange(8, 12) || (double)k > WyHelper.randomWithRange(8, 12) ? WyHelper.randomWithRange(-5, 5) : 0.0))).func_177230_c().equals(Blocks.field_150354_m)) continue;
                    this.blockPlacingHelper.addBlockPos(posX, posY, posZ, i * i + j * j + k * k);
                }
            }
        }
        if (this.blockPlacingHelper.getBlockList().size() <= 0) {
            return false;
        }
        PARTICLES1.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{this.getName()}));
            return false;
        }
        return (ability == null || !ability.isCharging()) && !player.func_70026_G();
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1, false, false));
        HashSet<BlockPos> blockList = this.blockPlacingHelper.getBlockList();
        int finished = blockList.size() / 100;
        Iterator<BlockPos> iterator = blockList.iterator();
        while (iterator.hasNext()) {
            BlockPos blockPos = iterator.next();
            if (finished-- < 0) break;
            BlockPos pos = new BlockPos((Vec3i)blockPos);
            AbilityHelper.placeBlockIfAllowed(player.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), ModBlocks.SUNA_SAND, DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
            iterator.remove();
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        PARTICLES2.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        return true;
    }

    public static boolean isFruitBoosted(PlayerEntity player) {
        return player.func_130014_f_().func_226691_t_(player.func_180425_c()).func_201856_r().equals((Object)Biome.Category.DESERT) || player.func_130014_f_().func_226691_t_(player.func_180425_c()).func_201856_r().equals((Object)Biome.Category.BEACH);
    }
}

