/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGirasoleAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.DesertSpadaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class DesertSpadaAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new DesertSpadaAbility();

    public DesertSpadaAbility() {
        super("Desert Spada", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(8.0);
        this.setMaxChargeTime(1.0);
        this.setDescription("The user forms his hand into a blade and stabs it into the ground, creating a sand blade that destroys anything on its path");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (!player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 2, 1, false, false));
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.DESERT_SPADA_SFX, SoundCategory.PLAYERS, 2.0f, 2.0f);
        boolean fruitBoosted = DesertGirasoleAbility.isFruitBoosted(player);
        DesertSpadaProjectile proj = new DesertSpadaProjectile(player.field_70170_p, (LivingEntity)player);
        proj.setMaxLife(fruitBoosted ? 30 : 20);
        proj.setDamage(proj.getDamage() * (fruitBoosted ? 1.5f : 1.0f));
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 1.0f);
        return true;
    }
}

