/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.abilities.suna.DesertGirasoleAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.suna.SablesPesadoProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.SablesParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class SablesPesadoAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new SablesPesadoAbility();
    private static final SablesParticleEffect PARTICLES = new SablesParticleEffect();

    public SablesPesadoAbility() {
        super("Sables: Pesado", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(25.0);
        this.setMaxChargeTime(5.0);
        this.setDescription("The user compresses a sandstorm to its limits and shoots it at extreme speeds");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        this.setChargeTime(DesertGirasoleAbility.isFruitBoosted(player) ? (int)((float)this.getMaxChargeTime() * 0.5f) : this.getMaxChargeTime());
        return !player.func_70026_G();
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 2, 1, false, false));
        player.func_195064_c(new EffectInstance(ModEffects.REDUCED_FALL, 2, 1, false, false));
        SablesPesadoAbility.PARTICLES.mult = 1.0f - (float)i / ((float)this.getMaxChargeTime() * 10.0f);
        if (i % 5 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b, player.func_213322_ci().field_72449_c);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.SABLES_PESADO_SFX, SoundCategory.PLAYERS, 2.0f, 2.0f);
        SablesPesadoProjectile proj = new SablesPesadoProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.25f, 4.0f);
        return true;
    }
}

