/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.supa;

import java.awt.Color;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class SpiderAbility
extends ContinuousAbility
implements IBodyOverlayAbility {
    public static final SpiderAbility INSTANCE = new SpiderAbility();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.DOKU_COATING).setColor(new Color(33, 26, 26, 158));

    public SpiderAbility() {
        super("Spider", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(15.0);
        this.setDescription("Hardens the user's body to protect themselves, but they're unable to move");
        this.setInPool(AbilityPool.TEKKAI_LIKE);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        player.func_195064_c(new EffectInstance(ModEffects.GUARDING, 2, 3, false, false));
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)Math.round((double)this.continueTime / 15.0);
        this.setMaxCooldown(cooldown);
        return true;
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }
}

