/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.swordsman;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.swordsman.HiryuKaenParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class HiryuKaenAbility
extends Ability
implements IMultiTargetAbility,
IFallDamageBlockingAbility {
    public static final HiryuKaenAbility INSTANCE = new HiryuKaenAbility();
    public static final HiryuKaenParticleEffect PARTICLES = new HiryuKaenParticleEffect();
    private boolean wasActivated = false;
    private boolean canHit = false;
    private boolean hasFallDamage = true;

    public HiryuKaenAbility() {
        super("Hiryu: Kaen", AbilityHelper.getStyleCategory());
        this.setDescription("The user leaps into the air and releases a big flaming shockwave slash when landing");
        this.setMaxCooldown(15.0);
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
        this.onEndCooldownEvent = this::onEndCooldown;
    }

    private void onEndCooldown(PlayerEntity player) {
        this.wasActivated = false;
    }

    private void duringCooldown(PlayerEntity player, int cooldown) {
        if ((double)cooldown < this.getMaxCooldown() && !this.canHit && !player.field_70122_E && !this.wasActivated) {
            this.canHit = true;
            this.wasActivated = true;
        }
        if (player.field_70122_E && this.canHit) {
            List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 4.5, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            targets.remove(player);
            for (LivingEntity entity : targets) {
                if (!this.isTarget(entity) || !player.func_70685_l((Entity)entity)) continue;
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 18.0f);
                entity.func_70015_d(4);
            }
            if (targets.size() > 0) {
                ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            }
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            this.canHit = false;
        }
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseSwordsmanAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SWORD, new Object[0]));
            return false;
        }
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.clearTargets();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 1.0, 1.0);
        player.func_213293_j(speed.field_72450_a, 1.3, speed.field_72449_c);
        player.field_70133_I = true;
        this.canHit = false;
        this.hasFallDamage = false;
        return true;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        this.hasFallDamage = true;
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

