/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixAssaultPointAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.PhoenixAssaultZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class BlueBirdAbility
extends ChargeableAbility {
    public static final BlueBirdAbility INSTANCE = new BlueBirdAbility();
    private List<LivingEntity> list = new ArrayList<LivingEntity>();

    public BlueBirdAbility() {
        super("Blue Bird", AbilityHelper.getDevilFruitCategory());
        this.setMaxChargeTime(5.0);
        this.setMaxCooldown(15.0);
        this.setDescription("While in the air, the user builds up momentum through blue flames, to deliver a devastating kick");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.list.clear();
        if (!PhoenixAssaultZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), PhoenixAssaultPointAbility.INSTANCE.getName()}));
            return false;
        }
        if (player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_AIR, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int time) {
        float incrementPI = 0.049087387f;
        float radius1 = (float)BlueBirdAbility.fromRangeToRange(0.0, this.getMaxChargeTime(), 0.15, 1.25, this.getMaxChargeTime() - time);
        float radius2 = (float)BlueBirdAbility.fromRangeToRange(0.0, this.getMaxChargeTime(), 0.05, 0.3, this.getMaxChargeTime() - time);
        float rotation = (float)((double)incrementPI * BlueBirdAbility.fromRangeToRange(0.0, this.getMaxChargeTime(), -128.0, 128.0, time));
        float rotation2 = (float)((double)incrementPI * BlueBirdAbility.fromRangeToRange(0.0, this.getMaxChargeTime(), -128.0, 128.0, time) + 2.0943951023931953);
        float rotation3 = (float)((double)incrementPI * BlueBirdAbility.fromRangeToRange(0.0, this.getMaxChargeTime(), -128.0, 128.0, time) - 2.0943951023931953);
        Vec3d normalizedH = BlueBirdAbility.getPerpendicularHorizontalLine(Vec3d.field_186680_a, player.func_70040_Z(), radius1);
        Vec3d normalizedV = BlueBirdAbility.getPerpendicularVerticalLine(Vec3d.field_186680_a, player.func_70040_Z(), normalizedH.func_216372_d(-Math.PI, -Math.PI, -Math.PI), radius2);
        Vec3d finalPosition1 = BlueBirdAbility.getParticlePositionInSpiral(rotation, normalizedH, normalizedV);
        Vec3d finalPosition2 = BlueBirdAbility.getParticlePositionInSpiral(rotation2, normalizedH, normalizedV);
        Vec3d finalPosition3 = BlueBirdAbility.getParticlePositionInSpiral(rotation3, normalizedH, normalizedV);
        GenericParticleData data = new GenericParticleData(ModParticleTypes.BLUE_FLAME);
        data.setLife(15);
        data.setSize(2.0f);
        data.setMotion(player.func_70040_Z().func_82615_a() / 10.0, player.func_70040_Z().func_82617_b() / 10.0, player.func_70040_Z().func_82616_c() / 10.0);
        double posX = player.func_226277_ct_() + finalPosition1.field_72450_a;
        double posY = player.func_226280_cw_() + finalPosition1.field_72448_b;
        double posZ = player.func_226281_cx_() + finalPosition1.field_72449_c;
        double posX2 = player.func_226277_ct_() + finalPosition2.field_72450_a;
        double posY2 = player.func_226280_cw_() + finalPosition2.field_72448_b;
        double posZ2 = player.func_226281_cx_() + finalPosition2.field_72449_c;
        double posX3 = player.func_226277_ct_() + finalPosition3.field_72450_a;
        double posY3 = player.func_226280_cw_() + finalPosition3.field_72448_b;
        double posZ3 = player.func_226281_cx_() + finalPosition3.field_72449_c;
        WyHelper.spawnParticles(data, (ServerWorld)player.field_70170_p, posX, posY, posZ);
        WyHelper.spawnParticles(data, (ServerWorld)player.field_70170_p, posX2, posY2, posZ2);
        WyHelper.spawnParticles(data, (ServerWorld)player.field_70170_p, posX3, posY3, posZ3);
        if (!(player.field_70122_E || time != 1 && time != 4 && time != 8 && time != 10)) {
            player.func_213317_d(player.func_70040_Z().func_216369_h(new Vec3d(5.0 * ((double)time / 10.0), 5.0, 5.0 * ((double)time / 10.0))));
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            player.field_70143_R = 0.0f;
        }
        if (time < 20) {
            List exList = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 2.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            exList.remove(player);
            exList.removeIf(o -> this.list.contains(o));
            this.list.addAll(exList);
            if (time == 1) {
                for (LivingEntity target : this.list) {
                    target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 25.0f);
                }
            }
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        this.list.clear();
        return true;
    }

    private static Vec3d getPerpendicularHorizontalLine(Vec3d startPoint, Vec3d endPoint, float radius) {
        Vec3d line;
        Vec3d axis = new Vec3d(1.0, 0.0, 1.0);
        Vec3d newStart = startPoint.func_216369_h(axis);
        Vec3d newEnd = endPoint.func_216369_h(axis);
        line.func_72441_c((line = newEnd.func_178788_d(newStart)).func_82615_a() == 0.0 ? 0.001 : 0.0, 0.0, line.func_82616_c() == 0.0 ? 0.001 : 0.0);
        Vec3d newLine = new Vec3d(line.func_82616_c(), 0.0, -line.func_82615_a());
        return newLine.func_72432_b().func_216372_d((double)radius, (double)radius, (double)radius);
    }

    private static Vec3d getPerpendicularVerticalLine(Vec3d startPoint, Vec3d endPoint, Vec3d horizontalPoint, float radius) {
        Vec3d vec1 = endPoint.func_178788_d(startPoint);
        Vec3d vec2 = horizontalPoint.func_178788_d(startPoint);
        Vec3d newLine = vec1.func_72431_c(vec2);
        return newLine.func_72432_b().func_216372_d((double)radius, (double)radius, (double)radius);
    }

    private static double fromRangeToRange(double oldMin, double oldMax, double min, double max, double oldValue) {
        return (oldValue - oldMin) * (max - min) / (oldMax - oldMin) + min;
    }

    private static Vec3d getParticlePositionInSpiral(float rotation, Vec3d normalizedH, Vec3d normalizedV) {
        Vec3d incrementH = normalizedH.func_216372_d(Math.cos(rotation), Math.cos(rotation), Math.cos(rotation));
        Vec3d incrementV = normalizedV.func_216372_d(Math.sin(rotation), Math.sin(rotation), Math.sin(rotation));
        Vec3d HVVec = incrementV.func_178788_d(incrementH);
        return incrementV.func_178787_e(HVVec.func_216372_d(0.5, 0.5, 0.5));
    }
}

