/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.UUID;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.ZoanAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.PhoenixFlyZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.effects.common.LogiaParticleEffect;

public class PhoenixFlyPointAbility
extends ZoanAbility {
    public static final PhoenixFlyPointAbility INSTANCE = new PhoenixFlyPointAbility();
    private static final AttributeModifier REGEN_RATE_MODIFIER = new AttributeModifier(UUID.fromString("eb43ce22-3c5a-45a0-810c-03c0f552efe7"), "Health Regeneration Speed Multiplier", 1.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private final LogiaParticleEffect particleEffect = new LogiaParticleEffect(ModParticleTypes.BLUE_FLAME);
    public float speed = 0.0f;

    public PhoenixFlyPointAbility() {
        super("Phoenix Fly Point", AbilityHelper.getDevilFruitCategory(), PhoenixFlyZoanInfo.INSTANCE);
        this.setDescription("Transforms the user into a phoenix, which focuses on speed and healing, Allows the user to use 'Phoenix Goen', 'Tensei no Soen'");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.addZoanModifier(ModAttributes.REGEN_RATE, REGEN_RATE_MODIFIER);
    }

    @Override
    public void duringContinuityEvent(PlayerEntity player, int activeTime) {
        super.duringContinuityEvent(player, activeTime);
        if (player.func_110138_aP() > player.func_110143_aJ() && !AbilityHelper.isNearbyKairoseki(player) && player.func_71024_bL().func_75116_a() > 0) {
            this.particleEffect.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), Math.random(), 0.0, Math.random());
            this.particleEffect.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() - Math.random(), player.func_226281_cx_(), Math.random(), 0.0, Math.random());
            this.particleEffect.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + Math.random(), player.func_226281_cx_(), Math.random(), 0.0, Math.random());
            int exhaustion = (int)(5.0 * Math.floor(Math.abs(player.func_71024_bL().func_75116_a() / 5)));
            if (activeTime % (20 + (10 - exhaustion / 2)) == 0 && player.field_70172_ad == 0) {
                player.func_70691_i(1.0f + (float)exhaustion / 10.0f);
                player.func_71020_j(0.25f + (float)exhaustion / 80.0f);
            }
        }
        player.field_70143_R = 0.0f;
    }

    @Override
    protected boolean onStartContinuityEvent(PlayerEntity player) {
        if (!super.onStartContinuityEvent(player)) {
            return false;
        }
        if (player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_AIR, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }
}

