/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ushibison;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ushibison.BisonHeavyPointAbility;
import xyz.pixelatedw.mineminenomi.abilities.ushibison.BisonWalkPointAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.BisonHeavyZoanInfo;
import xyz.pixelatedw.mineminenomi.entities.zoan.BisonWalkZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class FiddleBanffAbility
extends Ability
implements IMultiTargetAbility {
    public static final FiddleBanffAbility INSTANCE = new FiddleBanffAbility();

    public FiddleBanffAbility() {
        super("Fiddle Banff", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(7.0);
        this.setDescription("The transformed user dashes towards the opponent to crash against them with great power");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!BisonHeavyZoanInfo.INSTANCE.isActive((LivingEntity)player) && !BisonWalkZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_DOUBLE, new Object[]{this.getName(), BisonHeavyPointAbility.INSTANCE.getName(), BisonWalkPointAbility.INSTANCE.getName()}));
            return false;
        }
        this.clearTargets();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 5.0, 5.0);
        player.func_213293_j(speed.field_72450_a, player.func_213322_ci().func_82617_b(), speed.field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            for (LivingEntity target : list) {
                if (!this.isTarget(target)) continue;
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 8.0f);
            }
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > 100.0;
    }
}

