/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.wara;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.StrawDollItem;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;

public class StrawManAbility
extends PunchAbility {
    public static final Ability INSTANCE = new StrawManAbility();

    public StrawManAbility() {
        super("Straw Man", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Creates a doll that representing the entity you attacked, any damage will get redirected to it");
        this.setMaxCooldown(30.0);
        this.onHitEntityEvent = this::onHitEntity;
    }

    private float onHitEntity(PlayerEntity player, LivingEntity target) {
        IEntityStats targetProps = EntityStatsCapability.get(target);
        int dolls = player.field_71071_by.func_213901_a(ModItems.STRAW_DOLL);
        if (dolls < 5) {
            if (AbilityHelper.isTargetBlockingAbility(player, target)) {
                return 1.0f;
            }
            if (targetProps.hasStrawDoll()) {
                ItemStack doll = new ItemStack((IItemProvider)ModItems.STRAW_DOLL);
                ((StrawDollItem)doll.func_77973_b()).setStrawDollOwner(doll, target);
                doll.func_200302_a((ITextComponent)new StringTextComponent(target.func_195051_bN().func_197037_c() + "'s Straw Doll"));
                player.field_71071_by.func_70441_a(doll);
                targetProps.setStrawDoll(false);
            }
        }
        return 1.0f;
    }
}

