/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.BlackHoleParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class BlackHoleAbility
extends ChargeableAbility {
    public static final BlackHoleAbility INSTANCE = new BlackHoleAbility();
    private static final ParticleEffect PARTICLES = new BlackHoleParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE);

    public BlackHoleAbility() {
        super("Black Hole", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(20.0);
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.setDescription("The user spreads darkness over the target area, which engulfs and suffocates anyone and anything inside of it");
        this.onEndChargingEvent = this::endChargingEvent;
    }

    private boolean endChargingEvent(PlayerEntity player) {
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float multiplier = 1.0f - time;
        int range = (int)(12.0f * multiplier);
        if (range < 3) {
            return false;
        }
        AbilityHelper.createFilledSphere(player.field_70170_p, (int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_(), (int)(10.0f * multiplier), ModBlocks.DARKNESS, GRIEF_RULE);
        this.setCooldown((int)(this.getMaxCooldown() / 20.0 * (double)multiplier));
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.MAGU_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

