/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.yami.DarkMatterProjectile;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.DarkMatterChargingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class DarkMatterAbility
extends ChargeableAbility {
    public static final DarkMatterAbility INSTANCE = new DarkMatterAbility();
    private static final ParticleEffect PARTICLES = new DarkMatterChargingParticleEffect();

    public DarkMatterAbility() {
        super("Dark Matter", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Launches a ball of darkness that engulfs the opponent");
        this.setMaxCooldown(14.0);
        this.setMaxChargeTime(6.0);
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        if (chargeTime % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        DarkMatterProjectile proj = new DarkMatterProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.2f, 1.0f);
        return true;
    }
}

