/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yuki;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yuki.FubukiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.math.ISphere;
import xyz.pixelatedw.mineminenomi.wypi.math.Sphere;

public class FubukiAbility
extends Ability {
    public static final FubukiAbility INSTANCE = new FubukiAbility();
    private static final ParticleEffect PARTICLES = new FubukiParticleEffect();

    public FubukiAbility() {
        super("Fubuki", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setDescription("The user releases an extremely cold stream around themselves inflicting Frostbite and causing serious damage to those affected by it.");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(final PlayerEntity player) {
        if (CommonConfig.INSTANCE.isAbilityGriefingEnabled()) {
            Sphere.generate((int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_(), 25, new ISphere(){

                @Override
                public void call(int x, int y, int z) {
                    if (player.field_70170_p.func_175623_d(new BlockPos(x, y, z)) && player.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z)).func_200132_m() && player.field_70170_p.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c() != Blocks.field_150433_aE) {
                        player.field_70170_p.func_175656_a(new BlockPos(x, y, z), Blocks.field_150433_aE.func_176223_P());
                    }
                }
            });
        }
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 25.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        for (LivingEntity entity : targets) {
            AbilityHelper.addFrostbite(entity, (LivingEntity)player, 110);
            if (!entity.func_70644_a(ModEffects.FROSTBITE) && !entity.func_70644_a(ModEffects.FROZEN)) continue;
            entity.func_70097_a(ModDamageSource.SPECIAL.causeEntityDamageFromSource((Entity)player), 20.0f);
        }
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        return true;
    }
}

