/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zou;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.zou.ZouGuardPointAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.zoan.ZouGuardZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.baku.BakuMunchParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class IvoryDartAbility
extends Ability
implements IMultiTargetAbility {
    public static final IvoryDartAbility INSTANCE = new IvoryDartAbility();
    private static final ParticleEffect PARTICLES = new BakuMunchParticleEffect();
    private int initialY;

    public IvoryDartAbility() {
        super("Ivory Dart", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Launches the user forward in their elephant form, causing damage and destruction");
        this.setMaxCooldown(14.0);
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.clearTargets();
        if (!ZouGuardZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), ZouGuardPointAbility.INSTANCE.getName()}));
            return false;
        }
        this.initialY = (int)player.func_226278_cu_();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 4.0, 4.0);
        player.func_213293_j(speed.field_72450_a, player.func_213322_ci().func_82617_b(), speed.field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage() && player.func_226278_cu_() >= (double)this.initialY) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 20.0f);
                }
            });
            for (BlockPos location : WyHelper.getNearbyBlocks((LivingEntity)player, 4)) {
                if (!((double)location.func_177956_o() >= player.func_226278_cu_()) || !AbilityHelper.placeBlockIfAllowed(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), Blocks.field_150350_a, DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                PARTICLES.spawn(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.7;
    }
}

