/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class GraviZoneAbility
extends ContinuousAbility {
    public static final GraviZoneAbility INSTANCE = new GraviZoneAbility();
    private MODE activeMode = MODE.GUARD;

    public GraviZoneAbility() {
        super("Gravi Zone", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Creates a area where the user haves control over the momentum of everything\n\n\u00a72SHIFT-USE\u00a7r: Switches between GUARD and REJECT modes");
        this.onStartContinuityEvent = this::onStartContinuity;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.setMaxCooldown(10.0);
        this.setThreshold(8.0);
    }

    private boolean onStartContinuity(PlayerEntity player) {
        if (player.func_225608_bj_()) {
            if (this.activeMode == MODE.GUARD) {
                this.setThreshold(5.0);
                this.activeMode = MODE.REJECT;
                this.setCustomTexture("gravi_zone_reject");
            } else {
                this.setThreshold(8.0);
                this.activeMode = MODE.GUARD;
                this.setCustomTexture("gravi_zone");
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Ability mode set to: " + (Object)((Object)this.activeMode), new Object[0]));
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
            return false;
        }
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        int range = 3;
        if (this.activeMode == MODE.GUARD) {
            List<Entity> generalList = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, range += 5, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
            List<Entity> flyingList = WyHelper.getEntitiesNearSphere(player.func_180425_c().func_177982_a(0, 5, 0), player.field_70170_p, 5.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
            flyingList.remove(player);
            generalList.remove(player);
            generalList.forEach(entity -> {
                entity.func_70634_a(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s);
                if (entity instanceof LivingEntity) {
                    ((LivingEntity)entity).func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 0, false, false));
                }
                entity.field_70133_I = true;
            });
            flyingList.forEach(entity -> {
                if (entity instanceof AbilityProjectileEntity) {
                    entity.func_70634_a(entity.field_70169_q, entity.field_70167_r + 1.0, entity.field_70166_s);
                } else {
                    entity.func_70634_a(entity.field_70169_q, entity.field_70167_r, entity.field_70166_s);
                }
                entity.field_70133_I = true;
            });
            GraviZoneAbility.gravityRing((LivingEntity)player, range, 0, false);
            GraviZoneAbility.gravityRing((LivingEntity)player, range - 2, 4, false);
            GraviZoneAbility.gravityRing((LivingEntity)player, range - 4, 8, false);
        } else if (this.activeMode == MODE.REJECT) {
            List<Entity> list = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, range, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
            list.remove(player);
            list.forEach(entity -> {
                boolean causedDamage = true;
                if (entity instanceof LivingEntity) {
                    causedDamage = entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 10.0f);
                }
                if (causedDamage) {
                    entity.func_213293_j(-entity.func_213322_ci().field_72450_a * 3.0, entity instanceof AbilityProjectileEntity ? entity.func_213322_ci().field_72448_b : entity.func_213322_ci().field_72448_b * 2.0, -entity.func_213322_ci().field_72449_c * 3.0);
                    entity.field_70133_I = true;
                }
            });
            GraviZoneAbility.gravityRing((LivingEntity)player, range + 3, 4, false);
            GraviZoneAbility.gravityRing((LivingEntity)player, range + 2, 2, false);
            GraviZoneAbility.gravityRing((LivingEntity)player, range, 0, false);
        }
    }

    public static void gravityRing(LivingEntity entity, int range, int yOffset, boolean visibleOnlyFromOwner) {
        for (double z = 0.0; z < 7.283185307179586; z += 0.09817477042468103) {
            GenericParticleData data = new GenericParticleData(ModParticleTypes.GASU);
            data.setLife(12);
            data.setSize(2.0f);
            double offsetX = Math.cos(z) * (double)range;
            double offsetZ = Math.sin(z) * (double)range;
            data.setMotion(offsetX / 20.0, 0.0, offsetZ / 20.0);
            if (visibleOnlyFromOwner) {
                data.setEntityID(entity.func_145782_y());
                data.hideFromOthers();
            }
            WyHelper.spawnParticles(data, (ServerWorld)entity.field_70170_p, entity.func_226277_ct_() + offsetX, entity.func_226278_cu_() + 1.0 + (double)yOffset, entity.func_226281_cx_() + offsetZ);
        }
    }

    public static enum MODE {
        GUARD,
        REJECT;

    }
}

