/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.abilities.zushi.GraviZoneAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class JigokuTabiAbility
extends ContinuousAbility {
    public static final JigokuTabiAbility INSTANCE = new JigokuTabiAbility();

    public JigokuTabiAbility() {
        super("Jigoku Tabi", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Causes a powerful downward force of gravity, sending the enemies down in a crater");
        this.setMaxCooldown(20.0);
        this.setThreshold(12.0);
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuityEvent(PlayerEntity player, int activeTimer) {
        int range = 12;
        GraviZoneAbility.gravityRing((LivingEntity)player, range, 0, true);
        if (++activeTimer % 20 == 0) {
            List<LivingEntity> targets = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, range, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            targets.remove(player);
            for (LivingEntity entity : targets) {
                entity.func_213293_j(0.0, entity.func_213322_ci().field_72448_b - 4.0, 0.0);
                entity.field_70133_I = true;
                EffectInstance instance = new EffectInstance(Effects.field_76421_d, 25, 5, false, false);
                entity.func_195064_c(instance);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(entity.func_145782_y(), instance));
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 15.0f);
                GraviZoneAbility.gravityRing(entity, 3, 2, false);
                for (int x = -2; x < 2; ++x) {
                    for (int z = -2; z < 2; ++z) {
                        int posX = (int)entity.func_226277_ct_() + x;
                        int posY = (int)entity.func_226278_cu_() - 1;
                        int posZ = (int)entity.func_226281_cx_() + z;
                        AbilityHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_150350_a, DefaultProtectionRules.CORE_FOLIAGE_ORE);
                    }
                }
            }
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)Math.round((double)this.continueTime / 20.0) + 2;
        this.setMaxCooldown(cooldown);
        return true;
    }
}

