/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.zushi;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.abilities.zushi.GraviZoneAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.zushi.SagariNoRyuseiProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class SagariNoRyuseiAbility
extends RepeaterAbility {
    public static final SagariNoRyuseiAbility INSTANCE = new SagariNoRyuseiAbility();

    public SagariNoRyuseiAbility() {
        super("Sagari no Ryusei", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(45.0);
        this.setMaxRepeaterCount(4, 20);
        this.setDescription("Using gravity, the user pulls a nearby meteorites down on their enemies");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.setMaxRepeaterCount((int)WyHelper.randomWithRange(1, 4), 20);
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), player);
        for (int i = 2; i < 16; i += 2) {
            GraviZoneAbility.gravityRing((LivingEntity)player, 4, i, false);
        }
        return true;
    }

    private boolean onUseEvent(PlayerEntity player) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player);
        double x = mop.func_216347_e().field_72450_a;
        double y = mop.func_216347_e().field_72448_b;
        double z = mop.func_216347_e().field_72449_c;
        SagariNoRyuseiProjectile proj = new SagariNoRyuseiProjectile(player.field_70170_p, (LivingEntity)player);
        float size = this.getRepeaterCount() == this.getMaxRepeaterCount() ? (float)WyHelper.randomWithRange(24, 30) : (float)(WyHelper.randomWithRange(4, 8) * (double)this.getRepeaterCount());
        proj.setSize(size);
        proj.func_70012_b(x, y + 90.0, z, 0.0f, 0.0f);
        proj.func_213293_j(0.0, -1.85, 0.0);
        player.field_70170_p.func_217376_c((Entity)proj);
        return true;
    }
}

