/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.api.ZoanMorphModel;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.renderers.entities.zoans.ZoanMorphRenderer;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public abstract class ZoanInfo {
    public abstract AkumaNoMiItem getDevilFruit();

    public abstract String getForm();

    public abstract Ability getAbility();

    public boolean isActive(LivingEntity player) {
        return DevilFruitCapability.get(player).getZoanPoint().equalsIgnoreCase(this.getForm());
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("mineminenomi", "textures/models/zoanmorph/" + DevilFruitHelper.getDevilFruitKey(this.getDevilFruit()) + "_" + this.getForm() + ".png");
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory() {
        return new ZoanMorphRenderer.Factory(this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract ZoanMorphModel getModel();

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderModelHand() {
        return this.getModel() != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract void preRenderCallback(AbstractClientPlayerEntity var1, MatrixStack var2, float var3);

    public abstract Map<Pose, EntitySize> getSizes();

    public abstract double getHeight();

    public abstract float getShadowSize();
}

