/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.ProtectionEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.HardThrowableProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.KairosekiBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;

public class ExplosionAbility
extends Explosion {
    private World world;
    private Entity exploder;
    private double explosionX;
    private double explosionY;
    private double explosionZ;
    private float explosionSize;
    private ParticleEffect particles;
    private final List<BlockPos> affectedBlockPositions = Lists.newArrayList();
    private final Map<PlayerEntity, Vec3d> playerKnockbackMap = Maps.newHashMap();
    public List<FallingBlockEntity> removedBlocks = Lists.newArrayList();
    private final Random random = new Random();
    private boolean canStartFireAfterExplosion = false;
    private boolean canDestroyBlocks = true;
    private boolean canDropBlocksAfterExplosion = false;
    private boolean canDamageEntities = true;
    private boolean canDamageOwner = false;
    private boolean canAlwaysDamage = true;
    private boolean canProduceExplosionSound = true;
    private boolean protectOwnerFromFalling = false;
    private boolean canCauseKnockback = true;
    private boolean addRemovedBlocksToList = false;
    private float staticDamage = 0.0f;
    private float staticBlockResistance = 0.0f;
    private int heightDifference = 0;
    private int size = 52;

    public ExplosionAbility(Entity entity, World world, double posX, double posY, double posZ, float power) {
        super(world, entity, posX, posY, posZ, power, false, Explosion.Mode.DESTROY);
        this.world = world;
        this.exploder = entity;
        this.explosionSize = power;
        this.explosionX = posX;
        this.explosionY = posY;
        this.explosionZ = posZ;
    }

    public double getStaticDamage() {
        return this.staticDamage;
    }

    public void setStaticDamage(float damage) {
        this.staticDamage = damage;
    }

    public double getStaticBlockResistance() {
        return this.staticBlockResistance;
    }

    public void setStaticBlockResistance(float damage) {
        this.staticBlockResistance = damage;
    }

    public void setHeightDifference(int heightDifference) {
        this.heightDifference = heightDifference;
    }

    public void setDamageOwner(boolean damageOwner) {
        this.canDamageOwner = damageOwner;
    }

    public void setDamageEntities(boolean damageEntities) {
        this.canDamageEntities = damageEntities;
    }

    public void setDropBlocksAfterExplosion(boolean canDrop) {
        this.canDropBlocksAfterExplosion = canDrop;
    }

    public void setFireAfterExplosion(boolean hasFire) {
        this.canStartFireAfterExplosion = hasFire;
    }

    public void setDestroyBlocks(boolean canDestroyBlocks) {
        this.canDestroyBlocks = canDestroyBlocks;
    }

    public void setSmokeParticles(ParticleEffect particle) {
        this.particles = particle;
    }

    public boolean getAlwaysDamage() {
        return this.canAlwaysDamage;
    }

    public void setAlwaysDamage(boolean flag) {
        this.canAlwaysDamage = flag;
    }

    public void addRemovedBlocksToList() {
        this.addRemovedBlocksToList = true;
    }

    public void setProtectOwnerFromFalling(boolean flag) {
        this.protectOwnerFromFalling = flag;
    }

    public boolean hasSmokeParticles() {
        return this.particles != null;
    }

    public void setExplosionSound(boolean hasSound) {
        this.canProduceExplosionSound = hasSound;
    }

    private void resetDamage(LivingEntity entity) {
        entity.field_70172_ad = 0;
        entity.field_70737_aN = 0;
    }

    public void disableExplosionKnockback() {
        this.canCauseKnockback = false;
    }

    public void doExplosion() {
        boolean flag;
        boolean bl = flag = this.exploder != null && this.exploder instanceof PlayerEntity && AbilityHelper.checkForRestriction(this.world, (int)this.explosionX, (int)this.explosionY, (int)this.explosionZ);
        if (flag || this.heightDifference > 0 && this.exploder != null && this.exploder.func_226278_cu_() - (double)this.heightDifference > this.explosionY) {
            return;
        }
        HashSet set = Sets.newHashSet();
        if ((float)(this.size + 4) > this.explosionSize) {
            this.size = Math.max((int)(this.explosionSize + 4.0f), 16);
        }
        for (int j = 0; j < this.size; ++j) {
            for (int k = 0; k < this.size; ++k) {
                for (int l = 0; l < this.size; ++l) {
                    if (j != 0 && j != this.size - 1 && k != 0 && k != this.size - 1 && l != 0 && l != this.size - 1) continue;
                    double d0 = (float)j / (float)(this.size - 1) * 2.0f - 1.0f;
                    double d1 = (float)k / (float)(this.size - 1) * 2.0f - 1.0f;
                    double d2 = (float)l / (float)(this.size - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double eX = this.explosionX;
                    double eY = this.explosionY;
                    double eZ = this.explosionZ;
                    float f1 = 0.3f;
                    for (float f = this.explosionSize * (0.7f + this.world.field_73012_v.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos blockpos = new BlockPos(eX, eY, eZ);
                        BlockState blockState = this.world.func_180495_p(blockpos);
                        IFluidState ifluidstate = this.world.func_204610_c(blockpos);
                        if (!blockState.isAir((IBlockReader)this.world, blockpos) || !ifluidstate.func_206888_e()) {
                            float f2 = Math.max(blockState.getExplosionResistance((IWorldReader)this.world, blockpos, this.exploder, (Explosion)this), ifluidstate.getExplosionResistance((IWorldReader)this.world, blockpos, this.exploder, (Explosion)this));
                            if (this.exploder != null) {
                                f2 = this.exploder.func_180428_a((Explosion)this, (IBlockReader)this.world, blockpos, blockState, ifluidstate, f2);
                            }
                            f = (float)((double)f - (this.getStaticBlockResistance() > 0.0 ? this.getStaticBlockResistance() : (double)((f2 + 0.3f) * 0.3f)));
                        }
                        if (f > 0.0f && (this.exploder == null || this.exploder.func_174816_a((Explosion)this, (IBlockReader)this.world, blockpos, blockState, f))) {
                            set.add(blockpos);
                        }
                        eX += d0 * (double)0.3f;
                        eY += d1 * (double)0.3f;
                        eZ += d2 * (double)0.3f;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(set);
        float f3 = this.explosionSize * 2.0f;
        int k1 = MathHelper.func_76128_c((double)(this.explosionX - (double)f3 - 1.0));
        int l1 = MathHelper.func_76128_c((double)(this.explosionX + (double)f3 + 1.0));
        int i2 = MathHelper.func_76128_c((double)(this.explosionY - (double)f3 - 1.0));
        int i1 = MathHelper.func_76128_c((double)(this.explosionY + (double)f3 + 1.0));
        int j2 = MathHelper.func_76128_c((double)(this.explosionZ - (double)f3 - 1.0));
        int j1 = MathHelper.func_76128_c((double)(this.explosionZ + (double)f3 + 1.0));
        List list = this.canDamageOwner ? this.world.func_217357_a(LivingEntity.class, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1)) : this.world.func_72839_b(this.exploder, new AxisAlignedBB((double)k1, (double)i2, (double)j2, (double)l1, (double)i1, (double)j1));
        ForgeEventFactory.onExplosionDetonate((World)this.world, (Explosion)this, (List)list, (double)f3);
        Vec3d vec3d = new Vec3d(this.explosionX, this.explosionY, this.explosionZ);
        if (this.canDamageEntities) {
            for (int k2 = 0; k2 < list.size(); ++k2) {
                PlayerEntity playerEntity;
                double zDistance;
                double yDistance;
                double xDistance;
                double squareDistance;
                double distance;
                Entity entity = (Entity)list.get(k2);
                boolean isInProtection = AbilityHelper.checkForRestriction(this.world, (int)entity.func_226277_ct_(), (int)entity.func_226278_cu_(), (int)entity.func_226281_cx_());
                if (entity.func_180427_aV() || isInProtection || !((distance = entity.func_70092_e(this.explosionX, this.explosionY, this.explosionZ) / (double)f3) <= 1.0) || (squareDistance = (double)MathHelper.func_76133_a((double)((xDistance = entity.func_226277_ct_() - this.explosionX) * xDistance + (yDistance = entity.func_226278_cu_() + (double)entity.func_70047_e() - this.explosionY) * yDistance + (zDistance = entity.func_226281_cx_() - this.explosionZ) * zDistance))) == 0.0) continue;
                xDistance /= squareDistance;
                yDistance /= squareDistance;
                zDistance /= squareDistance;
                double blockDensity = this.getStaticBlockResistance() > 0.0 ? 0.0 : (double)Explosion.func_222259_a((Vec3d)vec3d, (Entity)entity);
                double power = (1.0 - distance) * blockDensity;
                if (entity instanceof LivingEntity && this.getAlwaysDamage()) {
                    this.resetDamage((LivingEntity)entity);
                }
                if (this.staticDamage > 0.0f) {
                    entity.func_70097_a(this.func_199591_b(), this.staticDamage);
                } else {
                    float damage = (float)((power * power + power) / 2.0 * 7.0 * (double)f3 + 1.0);
                    entity.func_70097_a(this.func_199591_b(), damage);
                }
                double blastDamageReduction = power;
                if (entity instanceof LivingEntity) {
                    blastDamageReduction = ProtectionEnchantment.func_92092_a((LivingEntity)((LivingEntity)entity), (double)power);
                }
                if (!this.canCauseKnockback) continue;
                entity.func_213317_d(entity.func_213322_ci().func_72441_c(xDistance * blastDamageReduction, yDistance * blastDamageReduction, zDistance * blastDamageReduction));
                if (!(entity instanceof PlayerEntity) || (playerEntity = (PlayerEntity)entity).func_175149_v() || playerEntity.func_184812_l_() && playerEntity.field_71075_bZ.field_75100_b) continue;
                this.playerKnockbackMap.put(playerEntity, new Vec3d(xDistance * power, yDistance * power, zDistance * power));
            }
        }
        if (this.canProduceExplosionSound) {
            this.world.func_184148_a((PlayerEntity)null, this.explosionX, this.explosionY, this.explosionZ, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (this.world.field_73012_v.nextFloat() - this.world.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
        if (this.hasSmokeParticles()) {
            this.particles.spawn(this.world, this.explosionX, this.explosionY, this.explosionZ, 0.0, 0.0, 0.0);
        }
        if (this.canDestroyBlocks && CommonConfig.INSTANCE.isAbilityGriefingEnabled()) {
            ObjectArrayList objectarraylist = new ObjectArrayList();
            Collections.shuffle(this.affectedBlockPositions, this.world.field_73012_v);
            for (BlockPos blockpos : this.affectedBlockPositions) {
                BlockState blockstate = this.world.func_180495_p(blockpos);
                if (blockstate.func_185904_a() == Material.field_151586_h && !CommonConfig.INSTANCE.getDestroyWater()) continue;
                boolean blockIsKairoseki = KairosekiBlockProtectionRule.INSTANCE.isBanned(blockstate.func_177230_c());
                boolean blockIsRestricted = RestrictedBlockProtectionRule.INSTANCE.isBanned(blockstate.func_177230_c());
                boolean hardBlockRestriction = this.addRemovedBlocksToList && HardThrowableProtectionRule.INSTANCE.isBanned(blockstate.func_177230_c());
                boolean inProtectedAreaFlag = ExtendedWorldData.get(this.world).isInsideRestrictedArea(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
                boolean fallingProtection = true;
                if (this.protectOwnerFromFalling && this.exploder != null) {
                    boolean bl2 = fallingProtection = Math.sqrt(this.exploder.func_70092_e((double)blockpos.func_177958_n(), this.exploder.func_226278_cu_(), (double)blockpos.func_177952_p())) > 1.5;
                }
                if (blockstate.isAir((IBlockReader)this.world, blockpos) || blockIsKairoseki || blockIsRestricted || hardBlockRestriction || !fallingProtection || inProtectedAreaFlag) continue;
                if (this.world instanceof ServerWorld && blockstate.canDropFromExplosion((IBlockReader)this.world, blockpos, (Explosion)this)) {
                    TileEntity tileentity = blockstate.hasTileEntity() ? this.world.func_175625_s(blockpos) : null;
                    LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerWorld)this.world).func_216023_a(this.world.field_73012_v).func_216015_a(LootParameters.field_216286_f, (Object)blockpos).func_216015_a(LootParameters.field_216289_i, (Object)ItemStack.field_190927_a).func_216021_b(LootParameters.field_216288_h, (Object)tileentity).func_216021_b(LootParameters.field_216281_a, (Object)this.exploder);
                    lootcontext$builder.func_216015_a(LootParameters.field_216290_j, (Object)Float.valueOf(this.explosionSize));
                    if (this.canDropBlocksAfterExplosion) {
                        blockstate.func_215693_a(lootcontext$builder).forEach(p_229977_2_ -> ExplosionAbility.func_229976_a_((ObjectArrayList<Pair<ItemStack, BlockPos>>)objectarraylist, p_229977_2_, blockpos));
                    }
                    if (this.addRemovedBlocksToList) {
                        this.removedBlocks.add(new FallingBlockEntity(this.world, (double)blockpos.func_177958_n(), (double)blockpos.func_177956_o(), (double)blockpos.func_177952_p(), blockstate));
                    }
                }
                blockstate.onBlockExploded(this.world, blockpos, (Explosion)this);
            }
        }
        if (this.canStartFireAfterExplosion && CommonConfig.INSTANCE.isAbilityGriefingEnabled()) {
            for (BlockPos blockpos1 : this.affectedBlockPositions) {
                boolean inProtectedAreaFlag = ExtendedWorldData.get(this.world).isInsideRestrictedArea(blockpos1.func_177958_n(), blockpos1.func_177956_o(), blockpos1.func_177952_p());
                if (!this.world.func_180495_p(blockpos1).isAir((IBlockReader)this.world, blockpos1) || !this.world.func_180495_p(blockpos1.func_177977_b()).func_200015_d((IBlockReader)this.world, blockpos1.func_177977_b()) || this.random.nextInt(3) != 0 || inProtectedAreaFlag) continue;
                this.world.func_175656_a(blockpos1, Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private static void func_229976_a_(ObjectArrayList<Pair<ItemStack, BlockPos>> p_229976_0_, ItemStack p_229976_1_, BlockPos p_229976_2_) {
        int i = p_229976_0_.size();
        for (int j = 0; j < i; ++j) {
            Pair pair = (Pair)p_229976_0_.get(j);
            ItemStack itemstack = (ItemStack)pair.getFirst();
            if (!ItemEntity.func_226532_a_((ItemStack)itemstack, (ItemStack)p_229976_1_)) continue;
            ItemStack itemstack1 = ItemEntity.func_226533_a_((ItemStack)itemstack, (ItemStack)p_229976_1_, (int)16);
            p_229976_0_.set(j, (Object)Pair.of((Object)itemstack1, (Object)((BlockPos)pair.getSecond())));
            if (!p_229976_1_.func_190926_b()) continue;
            return;
        }
        p_229976_0_.add((Object)Pair.of((Object)p_229976_1_, (Object)p_229976_2_));
    }

    public Map<PlayerEntity, Vec3d> func_77277_b() {
        return this.playerKnockbackMap;
    }
}

