/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.ZoanInfo;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SRecalculateEyeHeightPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public abstract class ZoanAbility
extends ContinuousAbility
implements IParallelContinuousAbility {
    private ZoanInfo zoanInfo;
    private HashMap<IAttribute, AttributeModifier> zoanModifiers = new HashMap();
    private HashMap<IAttribute, AttributeModifier> emptyHandZoanModifier = new HashMap();

    public ZoanAbility(String name, APIConfig.AbilityCategory category, ZoanInfo info) {
        super(name, category);
        this.zoanInfo = info;
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    public void duringContinuityEvent(PlayerEntity player, int i) {
        this.emptyHandZoanModifier.forEach(player.func_184614_ca().func_190926_b() ? (key, value) -> {
            if (player.func_110148_a(key).func_111127_a(value.func_111167_a()) == null) {
                player.func_110148_a(key).func_111121_a(value.func_111168_a(false));
            }
        } : (key, value) -> player.func_110148_a(key).func_111124_b(value.func_111168_a(false)));
    }

    protected boolean onStartContinuityEvent(PlayerEntity player) {
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        double zoanHeight = this.zoanInfo.getHeight();
        boolean hasEmptySpace = true;
        int i = 0;
        while ((double)i < zoanHeight) {
            BlockPos pos = player.func_180425_c().func_177982_a(0, i, 0);
            if (player.field_70170_p.func_217400_a(pos, (Entity)player)) {
                hasEmptySpace = false;
                break;
            }
            ++i;
        }
        if (!hasEmptySpace) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_SPACE, new Object[]{this.getName()}));
            return false;
        }
        if (props.getZoanPoint().isEmpty()) {
            props.setZoanPoint("");
        }
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.zoanModifiers.entrySet()) {
            player.func_110148_a(entry.getKey()).func_111124_b(entry.getValue().func_111168_a(false));
            player.func_110148_a(entry.getKey()).func_111121_a(entry.getValue().func_111168_a(false));
        }
        this.setState(Ability.State.CONTINUOUS);
        props.setZoanPoint(this.zoanInfo.getForm());
        WyNetwork.sendToAll(new SSyncDevilFruitPacket(player.func_145782_y(), props));
        WyNetwork.sendToAll(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps));
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EyeHeight((Entity)player, player.func_213283_Z(), player.func_213305_a(player.func_213283_Z()), player.func_213302_cg()));
        WyNetwork.sendToAllTrackingAndSelf(new SRecalculateEyeHeightPacket(player.func_145782_y()), (LivingEntity)player);
        player.func_213323_x_();
        return true;
    }

    protected boolean onEndContinuityEvent(PlayerEntity player) {
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        props.setZoanPoint("");
        for (Map.Entry<IAttribute, AttributeModifier> entry : this.zoanModifiers.entrySet()) {
            player.func_110148_a(entry.getKey()).func_111124_b(entry.getValue().func_111168_a(false));
        }
        WyNetwork.sendToAll(new SSyncDevilFruitPacket(player.func_145782_y(), props));
        WyNetwork.sendToAll(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps));
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EyeHeight((Entity)player, player.func_213283_Z(), player.func_213305_a(player.func_213283_Z()), player.func_213302_cg()));
        WyNetwork.sendToAllTrackingAndSelf(new SRecalculateEyeHeightPacket(player.func_145782_y()), (LivingEntity)player);
        player.func_213323_x_();
        return true;
    }

    protected boolean canMorphIn(PlayerEntity player, String form) {
        IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
        return WyHelper.isNullOrEmpty(props.getZoanPoint()) || props.getZoanPoint().equalsIgnoreCase(form);
    }

    public HashMap<IAttribute, AttributeModifier> getZoanModifiers() {
        return this.zoanModifiers;
    }

    public void addZoanModifier(IAttribute attr, AttributeModifier modifier) {
        this.zoanModifiers.put(attr, modifier);
    }

    public void addEmptyHandZoanModifier(IAttribute attr, AttributeModifier modifier) {
        this.zoanModifiers.put(attr, modifier);
        this.emptyHandZoanModifier.put(attr, modifier);
    }

    public ZoanInfo getZoanInfo() {
        return this.zoanInfo;
    }
}

