/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DevilFruitHelper {
    public static final ResourceLocation TIER_1_FRUITS = new ResourceLocation("mineminenomi", "dfboxes/tier1");
    public static final ResourceLocation TIER_2_FRUITS = new ResourceLocation("mineminenomi", "dfboxes/tier2");
    public static final ResourceLocation TIER_3_FRUITS = new ResourceLocation("mineminenomi", "dfboxes/tier3");
    private static String[][] zoanModels = new String[][]{{"ushi_ushi_bison", "bison"}, {"tori_tori_phoenix", "phoenix"}, {"ushi_ushi_giraffe", "giraffe"}, {"hito_hito_daibutsu", "daibutsu"}};

    @Nullable
    public static AkumaNoMiItem oneFruitPerWorldCheck(World world, @Nullable Item devilFruitItem) {
        boolean isAvailable;
        if (devilFruitItem == null || !(devilFruitItem instanceof AkumaNoMiItem)) {
            return null;
        }
        AkumaNoMiItem fruit = (AkumaNoMiItem)devilFruitItem;
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return fruit;
        }
        ExtendedWorldData worldProps = ExtendedWorldData.get(world);
        int tier = fruit.getTier();
        boolean bl = isAvailable = !worldProps.isDevilFruitInWorld(fruit);
        if (isAvailable) {
            worldProps.addDevilFruitInWorld(fruit);
            return fruit;
        }
        List fruitsLeft = WyHelper.shuffle(ModValues.devilfruits).stream().filter(f -> f.getTier() == tier && !worldProps.isDevilFruitInWorld((AkumaNoMiItem)((Object)f))).collect(Collectors.toList());
        if (fruitsLeft.size() > 0) {
            fruit = (AkumaNoMiItem)((Object)fruitsLeft.get(0));
            worldProps.addDevilFruitInWorld(fruit);
            return fruit;
        }
        return null;
    }

    @Nullable
    public static Item rouletteDevilFruits(World world, int tier) {
        Random rand = new Random();
        boolean hasUpgradeChance = (double)rand.nextInt(100) + rand.nextDouble() < 5.0;
        ResourceLocation pool = TIER_1_FRUITS;
        if (tier == 1) {
            pool = hasUpgradeChance ? TIER_2_FRUITS : TIER_1_FRUITS;
        }
        if (tier == 2) {
            pool = hasUpgradeChance ? TIER_3_FRUITS : TIER_2_FRUITS;
        } else if (tier == 3) {
            pool = TIER_3_FRUITS;
        }
        LootTable lootTable = world.func_73046_m().func_200249_aQ().func_186521_a(pool);
        LootContext.Builder builder = new LootContext.Builder((ServerWorld)world);
        LootContext context = builder.func_216022_a(LootParameterSets.field_216260_a);
        List stacks = lootTable.func_216113_a(context);
        if (stacks.isEmpty()) {
            return null;
        }
        return ((ItemStack)stacks.get(0)).func_77973_b();
    }

    public static String getDevilFruitKey(AkumaNoMiItem fruit) {
        String key = "";
        try {
            key = WyHelper.getResourceName(fruit.getDevilFruitName()).replace("_no_mi", "").replace(":", "").replace(".", "").replace(",", "").replace("model_", "");
        }
        catch (ClassCastException ex) {
            System.out.println("Item " + new ItemStack((IItemProvider)fruit).func_200301_q() + " could not be converted into a key, the resulted key was " + key + "");
            ex.printStackTrace();
            key = "ERROR";
        }
        return key;
    }

    public static ItemStack getDevilFruitItem(String fullName) {
        String model = "";
        String fullModel = "";
        for (String[] s : zoanModels) {
            if (!fullName.equals(s[0])) continue;
            model = s[1];
            fullModel = "_model_" + model;
            break;
        }
        if (fullName.equals("yamidummy")) {
            fullName = "yami_yami";
        }
        String finalName = (!WyHelper.isNullOrEmpty(model) ? fullName.replace("_" + model, "") : fullName) + "_no_mi" + fullModel;
        return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation("mineminenomi", finalName)));
    }

    public static boolean hasDFLimitInInventory(PlayerEntity player) {
        ItemStack invStack;
        if (!CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            return false;
        }
        int inventoryDevilFruits = 0;
        ArrayList slots = new ArrayList();
        slots.addAll(player.field_71071_by.field_70462_a);
        slots.addAll(player.field_71071_by.field_184439_c);
        Iterator iterator = slots.iterator();
        while (iterator.hasNext() && ((invStack = (ItemStack)iterator.next()) == null || !(invStack.func_77973_b() instanceof AkumaNoMiItem) || ++inventoryDevilFruits < CommonConfig.INSTANCE.getInventoryLimitForFruits())) {
        }
        return inventoryDevilFruits >= CommonConfig.INSTANCE.getInventoryLimitForFruits();
    }

    public static boolean kairosekiChecks(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            return AbilityHelper.isNearbyKairoseki(playerEntity);
        }
        return WyHelper.isBlockNearby(entity, 1, ModBlocks.KAIROSEKI, ModBlocks.KAIROSEKI_ORE, ModBlocks.KAIROSEKI_BARS);
    }

    public static void vanillaFlightThreshold(LivingEntity entity, int height) {
        if (entity.func_226278_cu_() > (double)height) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, 0.25 * (double)((float)height / 5.0f), 0.0).func_216372_d(1.0, -0.15, 1.0));
            entity.field_70133_I = true;
        }
    }

    public static boolean isFlyingAtMaxHeight(PlayerEntity player, double maxDifference) {
        return maxDifference > DevilFruitHelper.getDifferenceToFloor(player);
    }

    public static double getDifferenceToFloor(PlayerEntity player) {
        Vec3d startVec = player.func_213303_ch();
        Vec3d endVec = startVec.func_72441_c(0.0, -256.0, 0.0);
        BlockRayTraceResult blockResult = player.field_70170_p.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.OUTLINE, RayTraceContext.FluidMode.ANY, (Entity)player));
        return startVec.func_178788_d((Vec3d)blockResult.func_216347_e()).field_72448_b;
    }
}

