/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;

public class FightingStyleHelper {
    private static final AttributeModifier BLACK_LEG_ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("aa257b39-effd-43b3-9034-615b21e49038"), "Black Leg Speed Multiplier", (double)0.3f, AttributeModifier.Operation.ADDITION).func_111168_a(true);
    private static final AttributeModifier BLACK_LEG_ATTACK_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("cd7d0526-005b-4ef2-a61f-0e941b0d6e1a"), "Black Leg Range Multiplier", 0.5, AttributeModifier.Operation.ADDITION).func_111168_a(true);

    public static boolean hasBlackLegModifiers(PlayerEntity player) {
        boolean flag1 = player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(FightingStyleHelper.getBlackLegStrengthModifier(player));
        boolean flag2 = player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_180374_a(BLACK_LEG_ATTACK_SPEED_MODIFIER);
        boolean flag3 = player.func_110148_a(ModAttributes.ATTACK_RANGE).func_180374_a(BLACK_LEG_ATTACK_RANGE_MODIFIER);
        return flag1 || flag2 || flag3;
    }

    public static void removeBlackLegModifiers(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(FightingStyleHelper.getBlackLegStrengthModifier(player));
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(BLACK_LEG_ATTACK_SPEED_MODIFIER);
        player.func_110148_a(ModAttributes.ATTACK_RANGE).func_111124_b(BLACK_LEG_ATTACK_RANGE_MODIFIER);
    }

    public static void applyBlackLegModifiers(PlayerEntity player) {
        FightingStyleHelper.removeBlackLegModifiers(player);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(FightingStyleHelper.getBlackLegStrengthModifier(player));
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(BLACK_LEG_ATTACK_SPEED_MODIFIER);
        player.func_110148_a(ModAttributes.ATTACK_RANGE).func_111121_a(BLACK_LEG_ATTACK_RANGE_MODIFIER);
    }

    public static boolean hasBrawlerModifiers(PlayerEntity player) {
        return player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(FightingStyleHelper.getBrawlerStrength(player));
    }

    public static void removeBrawlerModifiers(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(FightingStyleHelper.getBrawlerStrength(player));
    }

    public static void applyBrawlerModifiers(PlayerEntity player) {
        FightingStyleHelper.removeBrawlerModifiers(player);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(FightingStyleHelper.getBrawlerStrength(player));
    }

    private static AttributeModifier getBrawlerStrength(PlayerEntity player) {
        return new AttributeModifier(UUID.fromString("4e4d55e7-774b-4010-8722-a15f9da99807"), "Brawler Attack Multiplier", (double)(1.0f + (float)Math.min(EntityStatsCapability.get((LivingEntity)player).getDoriki(), 10000) * 5.0E-4f), AttributeModifier.Operation.ADDITION).func_111168_a(true);
    }

    private static AttributeModifier getBlackLegStrengthModifier(PlayerEntity player) {
        return new AttributeModifier(UUID.fromString("be5937cc-c1da-4891-9583-cebbab2134d3"), "Black Leg Attack Multiplier", (double)(2.0f + (float)Math.min(EntityStatsCapability.get((LivingEntity)player).getDoriki(), 10000) * 4.0E-4f), AttributeModifier.Operation.ADDITION).func_111168_a(true);
    }
}

