/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.util.Random;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiAuraAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.KenbunshokuHakiFutureSightAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IHakiAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.events.HakiGainEvents;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class HakiHelper {
    public static double getBusoshokuHardeningExpNeeded(PlayerEntity player) {
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        return 30.0 + WyHelper.randomWithRange(rand, -2, 25);
    }

    public static double getBusoshokuFullBodyExpNeeded(PlayerEntity player) {
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        return 50.0 + WyHelper.randomWithRange(rand, 0, 20);
    }

    public static double getBusoshokuImbuingExpNeeded(PlayerEntity player) {
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        return 30.0 + WyHelper.randomWithRange(rand, -5, 20);
    }

    public static double getKenbunshokuAuraExpNeeded(PlayerEntity player) {
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        return 30.0 + WyHelper.randomWithRange(rand, -5, 20);
    }

    public static double getKenbunshokuFutureSightExpNeeded(PlayerEntity player) {
        Random rand = player.func_70681_au();
        rand.setSeed(player.func_110124_au().getMostSignificantBits());
        return 50.0 + WyHelper.randomWithRange(rand, 0, 30);
    }

    public static String getHakiRank(HakiType type, PlayerEntity player) {
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        IHakiData hakiData = HakiDataCapability.get((LivingEntity)player);
        HakiRank rank = HakiRank.INITIATE;
        float exp = 0.0f;
        boolean check = false;
        if (type == HakiType.HARDENING) {
            exp = hakiData.getBusoshokuHardeningHakiExp();
            check = abilityData.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
        } else if (type == HakiType.IMBUING) {
            exp = hakiData.getBusoshokuImbuingHakiExp();
            check = abilityData.hasUnlockedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        } else if (type == HakiType.KENBUNSHOKU) {
            exp = hakiData.getKenbunshokuHakiExp();
            check = abilityData.hasUnlockedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        }
        if (exp >= 0.0f && exp < 15.0f) {
            rank = HakiRank.INITIATE;
        } else if (exp >= 15.0f && check) {
            if (exp >= 15.0f && exp < 30.0f) {
                rank = HakiRank.BEGINNER;
            } else if (exp >= 30.0f && exp < 50.0f) {
                rank = HakiRank.ADEPT;
            } else if (exp >= 50.0f && exp < 90.0f) {
                rank = HakiRank.PROFICIENT;
            } else if (exp >= 90.0f) {
                rank = HakiRank.MASTER;
            }
        }
        return new TranslationTextComponent(ModI18n.TRAINER_HAKI_RANK, new Object[]{rank}).func_150254_d();
    }

    @Deprecated
    public static String getHakiProgress(HakiType type, PlayerEntity player) {
        IHakiData hakiData = HakiDataCapability.get((LivingEntity)player);
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        if (type == HakiType.HARDENING) {
            float exp = hakiData.getBusoshokuHardeningHakiExp();
            boolean hasHardening = abilityData.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
            boolean hasFullbody = abilityData.hasUnlockedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
            if (!hasHardening) {
                String translatedAbility = new TranslationTextComponent(BusoshokuHakiHardeningAbility.INSTANCE.getI18nKey(), new Object[0]).func_150254_d();
                int avg = (int)(40.0f - exp);
                if (avg > 0) {
                    return new TranslationTextComponent(ModI18n.TRAINER_KEEP_TRAINING, new Object[]{avg, translatedAbility}).func_150254_d();
                }
                return new TranslationTextComponent(ModI18n.TRAINER_UNUSUAL_TRAINING, new Object[]{translatedAbility}).func_150254_d();
            }
            if (!hasFullbody) {
                String translatedAbility = new TranslationTextComponent(BusoshokuHakiFullBodyHardeningAbility.INSTANCE.getI18nKey(), new Object[0]).func_150254_d();
                int avg = (int)(60.0f - exp);
                if (avg > 0) {
                    return new TranslationTextComponent(ModI18n.TRAINER_KEEP_TRAINING, new Object[]{avg, translatedAbility}).func_150254_d();
                }
                return new TranslationTextComponent(ModI18n.TRAINER_UNUSUAL_TRAINING, new Object[]{translatedAbility}).func_150254_d();
            }
            return new TranslationTextComponent(ModI18n.TRAINER_FINISHED_HARDENING_TRAINING, new Object[0]).func_150254_d();
        }
        if (type == HakiType.IMBUING) {
            float exp = hakiData.getBusoshokuImbuingHakiExp();
            boolean hasImbuing = abilityData.hasUnlockedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
            if (!hasImbuing) {
                String translatedAbility = new TranslationTextComponent(BusoshokuHakiImbuingAbility.INSTANCE.getI18nKey(), new Object[0]).func_150254_d();
                int avg = (int)(40.0f - exp);
                if (avg > 0) {
                    return new TranslationTextComponent(ModI18n.TRAINER_KEEP_TRAINING, new Object[]{avg, translatedAbility}).func_150254_d();
                }
                return new TranslationTextComponent(ModI18n.TRAINER_UNUSUAL_TRAINING, new Object[]{translatedAbility}).func_150254_d();
            }
            return new TranslationTextComponent(ModI18n.TRAINER_FINISHED_IMBUING_TRAINING, new Object[0]).func_150254_d();
        }
        float exp = hakiData.getKenbunshokuHakiExp();
        boolean hasAura = abilityData.hasUnlockedAbility(KenbunshokuHakiAuraAbility.INSTANCE);
        boolean hasFutureSight = abilityData.hasUnlockedAbility(KenbunshokuHakiFutureSightAbility.INSTANCE);
        if (!hasAura) {
            String translatedAbility = new TranslationTextComponent(KenbunshokuHakiAuraAbility.INSTANCE.getI18nKey(), new Object[0]).func_150254_d();
            int avg = (int)(40.0f - exp);
            if (avg > 0) {
                return new TranslationTextComponent(ModI18n.TRAINER_KEEP_TRAINING, new Object[]{avg, translatedAbility}).func_150254_d();
            }
            return new TranslationTextComponent(ModI18n.TRAINER_UNUSUAL_TRAINING, new Object[]{translatedAbility}).func_150254_d();
        }
        if (!hasFutureSight) {
            String translatedAbility = new TranslationTextComponent(KenbunshokuHakiFutureSightAbility.INSTANCE.getI18nKey(), new Object[0]).func_150254_d();
            int avg = (int)(75.0f - exp);
            if (avg > 0) {
                return new TranslationTextComponent(ModI18n.TRAINER_KEEP_TRAINING, new Object[]{avg, translatedAbility}).func_150254_d();
            }
            return new TranslationTextComponent(ModI18n.TRAINER_UNUSUAL_TRAINING, new Object[]{translatedAbility}).func_150254_d();
        }
        return new TranslationTextComponent(ModI18n.TRAINER_FINISHED_OBSERVATION_TRAINING, new Object[0]).func_150254_d();
    }

    public static void checkForUnlocks(PlayerEntity player) {
        IHakiData props = HakiDataCapability.get((LivingEntity)player);
        IEntityStats statsProps = EntityStatsCapability.get((LivingEntity)player);
        if (statsProps.getDoriki() > 4000 && (double)props.getBusoshokuHardeningHakiExp() > HakiHelper.getBusoshokuHardeningExpNeeded(player)) {
            HakiGainEvents.giveHakiAbility(player, BusoshokuHakiHardeningAbility.INSTANCE);
            if (statsProps.getDoriki() > 5000 && (double)props.getBusoshokuHardeningHakiExp() > HakiHelper.getBusoshokuFullBodyExpNeeded(player)) {
                HakiGainEvents.giveHakiAbility(player, BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
            }
        }
        if (statsProps.getDoriki() > 4500 && (double)props.getBusoshokuImbuingHakiExp() > HakiHelper.getBusoshokuImbuingExpNeeded(player)) {
            HakiGainEvents.giveHakiAbility(player, BusoshokuHakiImbuingAbility.INSTANCE);
        }
        if (statsProps.getDoriki() > 1500 && (double)props.getKenbunshokuHakiExp() > HakiHelper.getKenbunshokuAuraExpNeeded(player)) {
            HakiGainEvents.giveHakiAbility(player, KenbunshokuHakiAuraAbility.INSTANCE);
            if (statsProps.getDoriki() > 6000 && (double)props.getKenbunshokuHakiExp() > HakiHelper.getKenbunshokuFutureSightExpNeeded(player)) {
                HakiGainEvents.giveHakiAbility(player, KenbunshokuHakiFutureSightAbility.INSTANCE);
            }
        }
        WyNetwork.sendToAllTrackingAndSelf(new SSyncHakiDataPacket(player.func_145782_y(), props), (LivingEntity)player);
    }

    public static boolean canUseHaki(PlayerEntity player, Ability ability) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        for (Ability abl : props.getEquippedAbilities(AbilityHelper.getHakiCategory())) {
            ContinuousAbility hakiAbility;
            if (abl == null || !(abl instanceof ContinuousAbility) || !(hakiAbility = (ContinuousAbility)abl).isContinuous()) continue;
            if (HakiHelper.getHakiType(hakiAbility) == HakiType.HARDENING && HakiHelper.getHakiType(ability) == HakiType.HARDENING) {
                return false;
            }
            if (HakiHelper.getHakiType(hakiAbility) == HakiType.IMBUING && HakiHelper.getHakiType(ability) == HakiType.IMBUING) {
                return false;
            }
            if (HakiHelper.getHakiType(hakiAbility) != HakiType.KENBUNSHOKU || HakiHelper.getHakiType(ability) != HakiType.KENBUNSHOKU) continue;
            return false;
        }
        return true;
    }

    public static boolean hasAnyHakiEnabled(LivingEntity entity) {
        IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
        BusoshokuHakiHardeningAbility busoHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
        boolean hasBusoHakiActive = busoHaki != null && busoHaki.isContinuous();
        BusoshokuHakiFullBodyHardeningAbility fullBodyBusoHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
        boolean hasFullBodyBusoHakiActive = fullBodyBusoHaki != null && fullBodyBusoHaki.isContinuous();
        BusoshokuHakiImbuingAbility imbuingHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        ItemStack heldItem = entity.func_184614_ca();
        boolean hasImbuingBusoHakiActive = !heldItem.func_190926_b() && imbuingHaki != null && imbuingHaki.isContinuous();
        boolean hasNPCBusoActive = entity instanceof OPEntity && ((OPEntity)entity).hasBusoHaki();
        return hasBusoHakiActive || hasFullBodyBusoHakiActive || hasNPCBusoActive || hasImbuingBusoHakiActive;
    }

    public static boolean hasHardeningActive(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            IAbilityData props = AbilityDataCapability.get(entity);
            BusoshokuHakiHardeningAbility busoHaki = props.getEquippedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
            boolean hasBusoHakiActive = busoHaki != null && busoHaki.isContinuous();
            BusoshokuHakiFullBodyHardeningAbility fullBodyBusoHaki = props.getEquippedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
            boolean hasFullBodyBusoHakiActive = fullBodyBusoHaki != null && fullBodyBusoHaki.isContinuous();
            return hasBusoHakiActive || hasFullBodyBusoHakiActive;
        }
        if (entity instanceof OPEntity) {
            boolean hasNPCBusoActive = ((OPEntity)entity).hasBusoHaki();
            return hasNPCBusoActive;
        }
        return false;
    }

    public static boolean hasImbuingActive(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            IAbilityData attackerAbilityProps = AbilityDataCapability.get(entity);
            BusoshokuHakiImbuingAbility imbuingHaki = attackerAbilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
            boolean hasImbuingBusoHakiActive = imbuingHaki != null && imbuingHaki.isContinuous();
            return hasImbuingBusoHakiActive;
        }
        if (entity instanceof OPEntity) {
            boolean hasNPCBusoActive = ((OPEntity)entity).hasBusoHaki();
            return hasNPCBusoActive;
        }
        return false;
    }

    public static HakiType getHakiType(Ability ability) {
        if (ability instanceof IHakiAbility) {
            return ((IHakiAbility)((Object)ability)).getType();
        }
        return HakiType.HARDENING;
    }

    public static float getTotalHakiExp(LivingEntity player) {
        return HakiDataCapability.get(player).getTotalHakiExp();
    }

    public static float getBusoHardeningHakiExp(LivingEntity player) {
        return HakiDataCapability.get(player).getBusoshokuHardeningHakiExp();
    }

    public static boolean checkForHakiOveruse(PlayerEntity player, int overuse) {
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        if (overuse != -1) {
            hakiProps.alterHakiOveruse(1 + overuse);
        }
        return !HakiHelper.canEnableHaki(player);
    }

    public static boolean canEnableHaki(PlayerEntity player) {
        return (double)HakiDataCapability.get((LivingEntity)player).getHakiOveruse() < (double)HakiHelper.getMaxOveruse(player) * 0.95;
    }

    public static float getMaxOveruse(PlayerEntity player) {
        return 2200.0f + HakiHelper.getTotalHakiExp((LivingEntity)player) * 32.0f;
    }

    static enum HakiRank {
        INITIATE,
        BEGINNER,
        ADEPT,
        PROFICIENT,
        MASTER;

    }
}

