/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.tileentity.ChestTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.CustomSpawnerTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class StructuresHelper {
    public static final List<BlockPos> SPAWNED_STRUCTURES = new ArrayList<BlockPos>();
    public static final int[] STRUCTURES_COUNT = new int[15];
    private static final HashMap<StructureSpawnType, Map<StructureFaction, List<EntityType>>> SPAWN_TYPES = new HashMap();

    @Nullable
    public static void spawnMobs(IWorld world, BlockPos pos, StructureFaction faction, StructureSpawnType type, int min, int max) {
        StructuresHelper.spawnMobs(world, pos, faction, type, (int)WyHelper.randomWithRange(min, max));
    }

    @Nullable
    public static void spawnMobs(IWorld world, BlockPos pos, StructureFaction faction, StructureSpawnType type, int amount) {
        if (world == null) {
            return;
        }
        List<EntityType> factionList = SPAWN_TYPES.get((Object)type).get((Object)faction);
        if (factionList == null || factionList.size() <= 0) {
            return;
        }
        EntityType spawnType = factionList.get((int)WyHelper.randomWithRange(0, factionList.size() - 1));
        if (spawnType == null) {
            return;
        }
        world.func_180501_a(pos, ModBlocks.CUSTOM_SPAWNER.func_176223_P(), 3);
        if (world.func_175625_s(pos) instanceof CustomSpawnerTileEntity) {
            CustomSpawnerTileEntity spawner = (CustomSpawnerTileEntity)world.func_175625_s(pos);
            spawner.setSpawnerLimit(amount);
            spawner.setSpawnerMob(spawnType);
        }
    }

    @Nullable
    public static void spawnLoot(IWorld world, BlockPos pos, ResourceLocation lootTable) {
        world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 3);
        TileEntity tile = world.func_175625_s(pos.func_177977_b());
        if (tile instanceof ChestTileEntity) {
            ((ChestTileEntity)tile).func_189404_a(lootTable, world.func_201674_k().nextLong());
        }
    }

    @Deprecated
    @Nullable
    private static EntityType chooseSpawnType(StructureFaction faction, StructureSpawnType type) {
        List<EntityType> factionList = SPAWN_TYPES.get((Object)type).get((Object)faction);
        if (factionList == null || factionList.size() <= 0) {
            return null;
        }
        return factionList.get((int)WyHelper.randomWithRange(0, factionList.size() - 1));
    }

    @Deprecated
    public static void setupSpawners(String function, IWorld world, BlockPos pos, StructureFaction faction) {
        StructuresHelper.setupSpawners(function, world, pos, faction, 30);
    }

    @Deprecated
    public static void setupSpawners(String function, IWorld world, BlockPos pos, StructureFaction faction, int playerDistance) {
        String[] func = function.split("_");
        if (!func[func.length - 1].equalsIgnoreCase("spawn")) {
            return;
        }
        EntityType type = null;
        CustomSpawnerTileEntity spawner = null;
        int spawnLimit = 1;
        try {
            if (func[0].startsWith("grunt")) {
                spawnLimit = Integer.parseInt(func[1].replace("x", ""));
                type = StructuresHelper.chooseSpawnType(faction, StructureSpawnType.GRUNT);
            } else if (func[0].startsWith("sniper")) {
                spawnLimit = Integer.parseInt(func[1].replace("x", ""));
                type = StructuresHelper.chooseSpawnType(faction, StructureSpawnType.SNIPER);
            } else if (func[0].startsWith("brute")) {
                spawnLimit = Integer.parseInt(func[1].replace("x", ""));
                type = StructuresHelper.chooseSpawnType(faction, StructureSpawnType.BRUTE);
            } else if (func[0].startsWith("captain")) {
                spawnLimit = 1;
                try {
                    spawnLimit = Integer.parseInt(func[1].replace("x", ""));
                }
                catch (Exception e) {
                    spawnLimit = 1;
                }
                type = StructuresHelper.chooseSpawnType(faction, StructureSpawnType.CAPTAIN);
            }
            if (type == null) {
                return;
            }
            world.func_180501_a(pos, ModBlocks.CUSTOM_SPAWNER.func_176223_P(), 3);
            if (world.func_175625_s(pos) instanceof CustomSpawnerTileEntity) {
                spawner = (CustomSpawnerTileEntity)world.func_175625_s(pos);
                spawner.setSpawnerLimit(spawnLimit);
                spawner.setSpawnerMob(type);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(pos);
            System.out.println(type);
            System.out.println(spawnLimit);
            System.out.println("=============================");
        }
    }

    static {
        SPAWN_TYPES.put(StructureSpawnType.GRUNT, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.MARINE_WITH_SWORD, ModEntities.MARINE_WITH_GUN}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.PIRATE_WITH_SWORD, ModEntities.PIRATE_WITH_GUN}), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.BANDIT_WITH_SWORD}), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.CAPTAIN, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.MARINE_CAPTAIN}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.PIRATE_CAPTAIN}), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.BRUTE, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.PIRATE_BRUTE}), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.BANDIT_BRUTE}), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.SNIPER, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.MARINE_SNIPER}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.BANDIT_SNIPER}), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.BOMBER, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.MARINE_BOMBER}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.BANDIT), (Object)Lists.newArrayList(), (Object)((Object)StructureFaction.REVOLUTIONARY), (Object)Lists.newArrayList()));
        SPAWN_TYPES.put(StructureSpawnType.TRADER, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.MARINE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.MARINE_TRADER}), (Object)((Object)StructureFaction.PIRATE), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.PIRATE_TRADER}), (Object)((Object)StructureFaction.SKYPIEAN), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.SKYPIEAN_TRADER})));
        SPAWN_TYPES.put(StructureSpawnType.CIVILIAN, (Map<StructureFaction, List<EntityType>>)ImmutableMap.of((Object)((Object)StructureFaction.SKYPIEAN), (Object)Lists.newArrayList((Object[])new EntityType[]{ModEntities.SKYPIEAN_CIVILIAN})));
    }

    public static enum StructureSpawnType {
        GRUNT,
        CAPTAIN,
        SNIPER,
        BRUTE,
        BOMBER,
        CIVILIAN,
        TRADER;

    }

    public static enum StructureFaction {
        MARINE,
        PIRATE,
        BANDIT,
        REVOLUTIONARY,
        SKYPIEAN;

    }
}

