/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.CannonTileEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CannonBlock
extends Block
implements IWaterLoggable {
    public static final DirectionProperty FACING = HorizontalBlock.field_185512_D;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;

    public CannonBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.5f).func_226896_b_());
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)FACING, (Comparable)Direction.NORTH)).func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockState blockstate = this.func_176223_P();
        BlockPos blockpos = context.func_195995_a();
        Direction[] adirection = context.func_196009_e();
        IFluidState ifluidstate = context.func_195991_k().func_204610_c(context.func_195995_a());
        for (Direction direction : adirection) {
            if (!direction.func_176740_k().func_176722_c()) continue;
            blockstate = (BlockState)blockstate.func_206870_a((IProperty)FACING, (Comparable)direction);
            if (!(blockstate = (BlockState)blockstate.func_206870_a((IProperty)WATERLOGGED, (Comparable)Boolean.valueOf(ifluidstate.func_206886_c() == Fluids.field_204546_a))).func_196955_c((IWorldReader)context.func_195991_k(), blockpos)) continue;
            return blockstate;
        }
        return null;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        CannonTileEntity tileEntity = (CannonTileEntity)world.func_175625_s(pos);
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        if (!player.func_184614_ca().func_190926_b()) {
            if (tileEntity.getGunpowederLoaded() < 5 && player.func_184614_ca().func_77973_b() == Items.field_151016_H) {
                player.func_184614_ca().func_190918_g(1);
                tileEntity.addGunpoweder();
                return ActionResultType.SUCCESS;
            }
            if (!tileEntity.hasCannonBall() && player.func_184614_ca().func_77973_b() == ModItems.CANNON_BALL) {
                player.func_184614_ca().func_190918_g(1);
                tileEntity.setHasCannonBall(true);
                return ActionResultType.SUCCESS;
            }
        }
        if (!world.field_72995_K && tileEntity.getGunpowederLoaded() > 0 && tileEntity.hasCannonBall()) {
            int damage = 30 + tileEntity.getGunpowederLoaded() * 2;
            int life = 100 + tileEntity.getGunpowederLoaded() * 20;
            float gravMod = (float)life / 10000.0f;
            float speed = gravMod * 100.0f;
            if (speed < 1.5f) {
                speed = 0.0f;
            }
            CannonBallProjectile proj = new CannonBallProjectile(player.field_70170_p, (LivingEntity)player);
            proj.func_70107_b(pos.func_177958_n(), (double)pos.func_177956_o() + 1.25, pos.func_177952_p());
            proj.setDamage(damage);
            proj.setMaxLife(life);
            proj.setGravity(0.04f - gravMod);
            world.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, 0.0f, ((Direction)state.func_177229_b((IProperty)FACING)).func_185119_l(), 0.0f, 3.0f + speed, 0.0f);
            for (int i = 0; i < 10; ++i) {
                double offsetX = WyHelper.randomDouble();
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble();
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197598_I, (double)pos.func_177958_n() + offsetX, (double)(pos.func_177956_o() + 1) + offsetY, (double)pos.func_177952_p() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
            }
            tileEntity.emptyGunpoweder();
            tileEntity.setHasCannonBall(false);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public IFluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((IProperty)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.func_177229_b((IProperty)WATERLOGGED)).booleanValue()) {
            worldIn.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)worldIn));
        }
        return facing.func_176734_d() == stateIn.func_177229_b((IProperty)FACING) && !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        return (BlockState)state.func_206870_a((IProperty)FACING, (Comparable)rot.func_185831_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        return state.func_185907_a(mirrorIn.func_185800_a((Direction)state.func_177229_b((IProperty)FACING)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{WATERLOGGED});
        builder.func_206894_a(new IProperty[]{FACING});
    }

    public boolean func_200123_i(BlockState state, IBlockReader reader, BlockPos pos) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return true;
    }

    public boolean func_229869_c_(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new CannonTileEntity();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }
}

