/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks.tileentities;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.challenges.ChallengeFailMessageThread;
import xyz.pixelatedw.mineminenomi.init.ModTileEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ChallengeArenaTileEntity
extends TileEntity
implements ITickableTileEntity {
    private int protectedSize = 10;
    private Challenge challenge;
    private String arenaName = "";
    private List<UUID> players = new ArrayList<UUID>();
    private List<LivingEntity> targets = new ArrayList<LivingEntity>();
    private int timer = 36000;
    private boolean isComplete = false;

    public ChallengeArenaTileEntity() {
        super(ModTileEntities.CHALLENGE_ARENA);
    }

    public void addPlayer(PlayerEntity player) {
        if (!this.players.contains(player.func_110124_au())) {
            this.players.add(player.func_110124_au());
        }
    }

    public void removePlayer(UUID uuid, @Nullable ServerPlayerEntity player) {
        if (player != null) {
            ServerWorld overworld = player.func_184102_h().func_71218_a(DimensionType.field_223227_a_);
            player.func_200619_a(overworld, (double)overworld.func_175694_M().func_177958_n(), (double)overworld.func_175694_M().func_177956_o(), (double)overworld.func_175694_M().func_177952_p(), 270.0f, 0.0f);
            if (!this.isComplete) {
                new ChallengeFailMessageThread(player).start();
            }
        }
        this.players.remove(uuid);
        this.challenge.getArenaData().isInUse = false;
        this.challenge.getArenaData().owner = null;
    }

    private void removeTargets() {
        Iterator<LivingEntity> targets = this.targets.iterator();
        if (targets.hasNext()) {
            LivingEntity entity = targets.next();
            entity.func_70106_y();
            this.targets.remove(entity);
        }
    }

    private void removePlayers() {
        Iterator<UUID> playersIterator = this.players.iterator();
        if (playersIterator.hasNext()) {
            UUID uuid = playersIterator.next();
            PlayerEntity player = this.field_145850_b.func_217371_b(uuid);
            this.removePlayer(uuid, (ServerPlayerEntity)player);
        }
    }

    private void removeExtra() {
        List<Entity> extras = WyHelper.getEntitiesNear(this.field_174879_c, this.field_145850_b, 100.0, Entity.class);
        for (Entity extra : extras) {
            if (extra instanceof ServerPlayerEntity) {
                ServerWorld overworld = extra.func_184102_h().func_71218_a(DimensionType.field_223227_a_);
                ((ServerPlayerEntity)extra).func_200619_a(overworld, (double)overworld.func_175694_M().func_177958_n(), (double)overworld.func_175694_M().func_177956_o(), (double)overworld.func_175694_M().func_177952_p(), 270.0f, 0.0f);
                continue;
            }
            extra.func_70106_y();
        }
    }

    public void addTarget(LivingEntity target) {
        this.targets.add(target);
    }

    public void setupArena(int size) {
        this.protectedSize = size;
        this.removeExtra();
    }

    public void setChallenge(Challenge challenge) {
        this.challenge = challenge;
        this.arenaName = challenge.getArenaName();
    }

    public int getSize() {
        return this.protectedSize;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.challenge == null || !this.challenge.hasStarted()) {
                return;
            }
            if (this.timer <= 0) {
                this.removePlayers();
                this.removeTargets();
                this.removeExtra();
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
            }
            if (this.players.isEmpty()) {
                this.removeTargets();
                this.removeExtra();
                this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                return;
            }
            if (!this.players.isEmpty()) {
                LivingEntity target;
                Iterator<UUID> playersIterator = this.players.iterator();
                if (playersIterator.hasNext()) {
                    UUID uuid = playersIterator.next();
                    PlayerEntity player = this.field_145850_b.func_217371_b(uuid);
                    if (player == null || !player.func_70089_S() || player.func_110143_aJ() <= 0.0f) {
                        this.removePlayer(uuid, (ServerPlayerEntity)player);
                        return;
                    }
                    double distance = player.func_195048_a(new Vec3d((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p()));
                    if (distance > (double)this.protectedSize) {
                        this.removePlayer(uuid, (ServerPlayerEntity)player);
                    }
                    if (this.targets.isEmpty()) {
                        this.removeExtra();
                        if (this.challenge != null) {
                            this.challenge.complete(player);
                            this.isComplete = true;
                            this.removePlayer(uuid, (ServerPlayerEntity)player);
                        }
                    }
                }
                if (this.players.isEmpty()) {
                    return;
                }
                Iterator<LivingEntity> targets = this.targets.iterator();
                if (targets.hasNext() && ((target = targets.next()) == null || !target.func_70089_S() || target.func_110143_aJ() <= 0.0f)) {
                    this.targets.remove(target);
                }
            }
            --this.timer;
        }
    }

    public void func_145839_a(CompoundNBT nbtTag) {
        super.func_145839_a(nbtTag);
        this.protectedSize = nbtTag.func_74762_e("Size");
        this.timer = nbtTag.func_74762_e("Timer");
        this.arenaName = nbtTag.func_74779_i("ArenaName");
    }

    public CompoundNBT func_189515_b(CompoundNBT nbtTag) {
        super.func_189515_b(nbtTag);
        nbtTag.func_74768_a("Size", this.protectedSize);
        nbtTag.func_74768_a("Timer", this.timer);
        nbtTag.func_74778_a("ArenaName", this.arenaName);
        return nbtTag;
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbttagcompound = new CompoundNBT();
        this.func_189515_b(nbttagcompound);
        return new SUpdateTileEntityPacket(this.field_174879_c, 9, this.func_189517_E_());
    }
}

