/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.commands.AbilityArgument;
import xyz.pixelatedw.mineminenomi.api.commands.AbilityGroupArgument;
import xyz.pixelatedw.mineminenomi.api.enums.AbilityCommandGroup;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class AbilityCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"ability").requires(source -> source.func_197034_c(3));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"give").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.addAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.addAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context)))))).then(Commands.func_197057_a((String)"remove").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"ability", (ArgumentType)new AbilityArgument()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.removeAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.removeAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context)))))).then(Commands.func_197057_a((String)"unlock_group").then(Commands.func_197056_a((String)"group", AbilityGroupArgument.abilityGroup()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.abilityGroup((CommandContext<CommandSource>)context, (AbilityCommandGroup)((Object)((Object)context.getArgument("group", AbilityCommandGroup.class))), 1, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))))).then(Commands.func_197057_a((String)"lock_group").then(Commands.func_197056_a((String)"group", AbilityGroupArgument.abilityGroup()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.abilityGroup((CommandContext<CommandSource>)context, (AbilityCommandGroup)((Object)((Object)context.getArgument("group", AbilityCommandGroup.class))), -1, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset_cooldown").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.resetCooldown((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.resetCooldown((CommandContext<CommandSource>)context, AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context))));
        dispatcher.register(builder);
    }

    private static int abilityGroup(CommandContext<CommandSource> context, AbilityCommandGroup group, int op, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            for (Ability abl : group.getAbilities()) {
                if (op == 1) {
                    abl.setUnlockType(AbilityUnlock.COMMAND);
                    abilityProps.addUnlockedAbility(abl);
                    continue;
                }
                abilityProps.removeUnlockedAbility(abl);
            }
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), (PlayerEntity)player);
        }
        return 1;
    }

    private static Collection<ServerPlayerEntity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int resetCooldown(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
            for (Ability ability : props.getEquippedAbilities()) {
                if (ability == null) continue;
                ability.setForcedState(false);
                if (ability.isOnCooldown()) {
                    ability.stopCooldown((PlayerEntity)player);
                }
                hakiProps.setHakiOveruse(0);
                WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket((PlayerEntity)player, ability), (LivingEntity)player);
            }
        }
        return 1;
    }

    private static int addAbility(CommandContext<CommandSource> context, Ability ability, Collection<ServerPlayerEntity> targets) {
        for (ServerPlayerEntity player : targets) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            ability.setUnlockType(AbilityUnlock.COMMAND);
            props.addUnlockedAbility(ability);
            if (WyDebug.isDebug()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + TextFormatting.ITALIC + "[DEBUG] " + ability.getName() + " unlocked for " + player.func_200200_C_().func_150254_d()));
            }
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        }
        return 1;
    }

    private static int removeAbility(CommandContext<CommandSource> context, Ability ability, Collection<ServerPlayerEntity> targets) {
        for (ServerPlayerEntity player : targets) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            props.removeUnlockedAbility(ability);
            if (WyDebug.isDebug()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + TextFormatting.ITALIC + "[DEBUG] " + ability.getName() + " removed for " + player.func_200200_C_().func_150254_d()));
            }
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        }
        return 1;
    }
}

