/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CheckPlayerCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"check_player").requires(source -> source.func_197034_c(2));
        ((LiteralArgumentBuilder)builder.executes(context -> CheckPlayerCommand.checkPlayer((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CheckPlayerCommand.checkPlayer((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))));
        dispatcher.register(builder);
    }

    private static int checkPlayer(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        IEntityStats statsData = EntityStatsCapability.get((LivingEntity)player);
        IDevilFruit fruitData = DevilFruitCapability.get((LivingEntity)player);
        ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
        Crew crew = worldData.getCrewWithMember(player.func_110124_au());
        StringBuilder builder = new StringBuilder();
        builder.append("===============================================\n");
        builder.append("Name: " + player.func_145748_c_().func_150254_d() + "\n");
        builder.append("Faction: " + statsData.getFaction() + "\n");
        if (statsData.isMarine() || statsData.isRevolutionary()) {
            builder.append("Loyalty: " + statsData.getLoyalty() + "\n");
            builder.append("Rank: " + statsData.getMarineRank().getLocalizedName() + "\n");
        }
        builder.append("Race: " + statsData.getRace() + "\n");
        builder.append("Style: " + statsData.getFightingStyle() + "\n");
        builder.append("Doriki: " + statsData.getDoriki() + "\n");
        builder.append("Belly: " + statsData.getBelly() + "\n");
        builder.append("Extol: " + statsData.getExtol() + "\n");
        builder.append("Bounty: " + statsData.getBounty() + "\n");
        builder.append("Crew: " + (crew != null ? crew.getName() : "None") + "\n");
        builder.append("Devil Fruit: " + (!WyHelper.isNullOrEmpty(fruitData.getDevilFruit()) ? fruitData.getDevilFruit() : "None") + "\n");
        builder.append("Damage Multiplier: " + statsData.getDamageMultiplier() + "\n");
        builder.append("===============================================");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), true);
        return 1;
    }
}

