/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.abilities.SpecialFlyAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SRecalculateEyeHeightPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class RemoveDFCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"removedf").requires(source -> source.func_197034_c(2));
        ((LiteralArgumentBuilder)builder.executes(context -> RemoveDFCommand.removesDF((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))).then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> RemoveDFCommand.removesDF((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))));
        dispatcher.register(builder);
    }

    private static int removesDF(CommandContext<CommandSource> context, ServerPlayerEntity player) throws CommandSyntaxException {
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
        worldData.removeAteDevilFruit((PlayerEntity)player);
        worldData.removeDevilFruitInWorld(devilFruitProps.getDevilFruit());
        devilFruitProps.setDevilFruit("");
        devilFruitProps.setLogia(false);
        devilFruitProps.setZoanPoint("");
        devilFruitProps.setYamiPower(false);
        for (Ability ability : abilityDataProps.getEquippedAbilities(APIConfig.AbilityCategory.ALL)) {
            if (ability == null) continue;
            if (ability instanceof ContinuousAbility) {
                ((ContinuousAbility)ability).stopContinuity((PlayerEntity)player);
                continue;
            }
            ability.stopCooldown((PlayerEntity)player);
        }
        if (CommonConfig.INSTANCE.isSpecialFlyingEnabled() && abilityDataProps.hasUnlockedAbility(SpecialFlyAbility.INSTANCE) && !player.func_184812_l_() && !player.func_175149_v()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
            player.field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        }
        abilityDataProps.clearUnlockedAbilities(AbilityHelper.getDevilFruitCategory());
        abilityDataProps.clearEquippedAbilities(AbilityHelper.getDevilFruitCategory());
        if (WyDebug.isDebug()) {
            player.func_195061_cb();
        }
        WyNetwork.sendToAllTrackingAndSelf(new SSyncDevilFruitPacket(player.func_145782_y(), devilFruitProps), (LivingEntity)player);
        WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityDataPacket(player.func_145782_y(), abilityDataProps), (LivingEntity)player);
        MinecraftForge.EVENT_BUS.post((Event)new EntityEvent.EyeHeight((Entity)player, player.func_213283_Z(), player.func_213305_a(player.func_213283_Z()), player.func_213302_cg()));
        WyNetwork.sendToAllTrackingAndSelf(new SRecalculateEyeHeightPacket(player.func_145782_y()), (LivingEntity)player);
        player.func_213323_x_();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "Removed Devil Fruit for " + player.func_145748_c_().func_150254_d()), true);
        return 1;
    }
}

