/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.challenges;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.registry.GameRegistry;
import xyz.pixelatedw.mineminenomi.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataBase;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class ChallengesDataCapability {
    @CapabilityInject(value=IChallengesData.class)
    public static final Capability<IChallengesData> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IChallengesData.class, (Capability.IStorage)new Capability.IStorage<IChallengesData>(){

            public INBT writeNBT(Capability<IChallengesData> capability, IChallengesData instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                ListNBT challenges = new ListNBT();
                for (int i = 0; i < instance.getChallenges().size(); ++i) {
                    Challenge challenge = instance.getChallenges().get(i);
                    CompoundNBT nbtData = new CompoundNBT();
                    nbtData.func_74778_a("id", challenge.getId());
                    nbtData.func_74757_a("complete", challenge.isComplete());
                    challenges.add((Object)nbtData);
                }
                props.func_218657_a("challenges", (INBT)challenges);
                return props;
            }

            public void readNBT(Capability<IChallengesData> capability, IChallengesData instance, Direction side, INBT nbt) {
                CompoundNBT props = (CompoundNBT)nbt;
                instance.clearChallenges();
                ListNBT challenges = props.func_150295_c("challenges", 10);
                try {
                    for (int i = 0; i < challenges.size(); ++i) {
                        CompoundNBT nbtData = challenges.func_150305_b(i);
                        Challenge challenge = ((Challenge)GameRegistry.findRegistry(Challenge.class).getValue(new ResourceLocation(APIConfig.projectId, nbtData.func_74779_i("id")))).create();
                        challenge.setComplete(nbtData.func_74767_n("complete"));
                        try {
                            instance.addChallenge(challenge);
                            continue;
                        }
                        catch (Exception e) {
                            WyDebug.debug("Unregistered challenge: " + nbtData.func_74779_i("id"));
                        }
                    }
                }
                catch (Exception e) {
                    WyDebug.debug("Error in finding a Challenge registry element. This might be due to the use of an old world. \nNothing to worry about but challenges from previous mod versions will revert to being uncompleted!");
                }
            }
        }, ChallengesDataBase::new);
    }

    public static IChallengesData get(PlayerEntity entity) {
        return (IChallengesData)entity.getCapability(INSTANCE, null).orElse((Object)new ChallengesDataBase());
    }

    public static LazyOptional<IChallengesData> getLazy(PlayerEntity entity) {
        return entity.getCapability(INSTANCE, null);
    }
}

