/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.entitystats;

import javax.annotation.Nullable;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class EntityStatsBase
implements IEntityStats {
    private int doriki;
    private int cola = 100;
    private int maxCola = 100;
    private int ultraCola = 0;
    private int marineLoyalty = 0;
    private long bounty;
    private long belly;
    private long extol;
    private String faction = "";
    private String race = "";
    private String subRace = "";
    private String fightingStyle = "";
    private boolean hasShadow = true;
    private boolean hasHeart = true;
    private boolean inCombatMode = false;
    private boolean hasStrawDoll = true;
    private double damageMultiplier = 1.0;

    @Override
    public int getDoriki() {
        return this.doriki;
    }

    @Override
    public void alterDoriki(int value) {
        this.doriki = MathHelper.func_76125_a((int)(this.doriki + value), (int)0, (int)CommonConfig.INSTANCE.getDorikiLimit());
    }

    @Override
    public void setDoriki(int value) {
        this.doriki = value <= CommonConfig.INSTANCE.getDorikiLimit() ? value : CommonConfig.INSTANCE.getDorikiLimit();
    }

    @Override
    public long getBelly() {
        return this.belly;
    }

    @Override
    public void alterBelly(long value) {
        this.belly = WyHelper.clamp(this.belly + value, 0L, 999999999L);
    }

    @Override
    public void setBelly(long value) {
        this.belly = value;
    }

    @Override
    public long getExtol() {
        return this.extol;
    }

    @Override
    public void alterExtol(long value) {
        this.extol = WyHelper.clamp(this.extol + value, 0L, 999999999L);
    }

    @Override
    public void setExtol(long value) {
        this.extol = value;
    }

    @Override
    public long getBounty() {
        return this.bounty;
    }

    @Override
    public void alterBounty(long value) {
        this.bounty = WyHelper.clamp(this.bounty + value, 0L, 100000000000L);
    }

    @Override
    public void setBounty(long value) {
        this.bounty = value;
    }

    @Override
    public int getCola() {
        return this.cola;
    }

    @Override
    public void alterCola(int value) {
        this.cola = this.cola + value < 0 ? 0 : (this.cola += value);
    }

    @Override
    public void setCola(int value) {
        this.cola = value;
    }

    @Override
    public int getMaxCola() {
        return this.maxCola;
    }

    @Override
    public void alterMaxCola(int value) {
        this.maxCola = this.maxCola + value < 0 ? 0 : (this.maxCola += value);
    }

    @Override
    public void setMaxCola(int value) {
        this.maxCola = value;
    }

    @Override
    public int getUltraCola() {
        return this.ultraCola;
    }

    @Override
    public void setUltraCola(int value) {
        this.ultraCola = this.ultraCola + value < 0 ? 0 : (this.ultraCola += value);
    }

    @Override
    public void addUltraCola(int value) {
        this.ultraCola += value;
    }

    @Override
    public int getLoyalty() {
        return this.marineLoyalty;
    }

    @Override
    public void alterLoyalty(int value) {
        this.marineLoyalty = MathHelper.func_76125_a((int)(this.marineLoyalty + value), (int)0, (int)100);
    }

    @Override
    public void setLoyalty(int value) {
        this.marineLoyalty = value;
    }

    @Override
    @Nullable
    public FactionHelper.MarineRank getMarineRank() {
        if (!this.isMarine()) {
            return null;
        }
        for (int i = 0; i < FactionHelper.MarineRank.values().length; ++i) {
            FactionHelper.MarineRank next;
            FactionHelper.MarineRank rank = FactionHelper.MarineRank.values()[i];
            FactionHelper.MarineRank marineRank = next = i + 1 < FactionHelper.MarineRank.values().length ? FactionHelper.MarineRank.values()[i + 1] : null;
            if (this.getLoyalty() < rank.getRequiredLoyalty() || next != null && this.getLoyalty() >= next.getRequiredLoyalty()) continue;
            return rank;
        }
        return FactionHelper.MarineRank.CHORE_BOY;
    }

    @Override
    public boolean hasMarineRank(FactionHelper.MarineRank rank) {
        if (!this.isMarine()) {
            return false;
        }
        return this.getMarineRank().ordinal() >= rank.ordinal();
    }

    @Override
    @Nullable
    public FactionHelper.RevolutionaryRank getRevolutionaryRank() {
        if (!this.isRevolutionary()) {
            return null;
        }
        for (int i = 0; i < FactionHelper.RevolutionaryRank.values().length; ++i) {
            FactionHelper.RevolutionaryRank next;
            FactionHelper.RevolutionaryRank rank = FactionHelper.RevolutionaryRank.values()[i];
            FactionHelper.RevolutionaryRank revolutionaryRank = next = i + 1 < FactionHelper.RevolutionaryRank.values().length ? FactionHelper.RevolutionaryRank.values()[i + 1] : null;
            if (this.getLoyalty() < rank.getRequiredLoyalty() || next != null && this.getLoyalty() >= next.getRequiredLoyalty()) continue;
            return rank;
        }
        return FactionHelper.RevolutionaryRank.MEMBER;
    }

    @Override
    public boolean hasRevolutionaryRank(FactionHelper.RevolutionaryRank rank) {
        if (!this.isRevolutionary()) {
            return false;
        }
        return this.getRevolutionaryRank().ordinal() >= rank.ordinal();
    }

    @Override
    public boolean isPirate() {
        if (WyHelper.isNullOrEmpty(this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("pirate");
    }

    @Override
    public boolean isMarine() {
        if (WyHelper.isNullOrEmpty(this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("marine");
    }

    @Override
    public boolean isBountyHunter() {
        if (WyHelper.isNullOrEmpty(this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("bounty_hunter");
    }

    @Override
    public boolean isRevolutionary() {
        if (WyHelper.isNullOrEmpty(this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("revolutionary");
    }

    @Override
    public boolean isBandit() {
        if (WyHelper.isNullOrEmpty(this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("bandit");
    }

    @Override
    public boolean isCivilian() {
        if (WyHelper.isNullOrEmpty(this.faction)) {
            return false;
        }
        return this.faction.equalsIgnoreCase("civilian");
    }

    @Override
    public boolean hasFaction() {
        return !WyHelper.isNullOrEmpty(this.faction);
    }

    @Override
    public void setFaction(String value) {
        this.faction = WyHelper.getResourceName(value);
    }

    @Override
    public String getFaction() {
        return this.faction;
    }

    @Override
    public boolean isHuman() {
        if (WyHelper.isNullOrEmpty(this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("human");
    }

    @Override
    public boolean isFishman() {
        if (WyHelper.isNullOrEmpty(this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("fishman");
    }

    @Override
    public boolean isCyborg() {
        if (WyHelper.isNullOrEmpty(this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("cyborg");
    }

    @Override
    public boolean isMink() {
        if (WyHelper.isNullOrEmpty(this.race)) {
            return false;
        }
        return this.race.equalsIgnoreCase("mink");
    }

    @Override
    public boolean hasRace() {
        return !WyHelper.isNullOrEmpty(this.race);
    }

    @Override
    public void setRace(String value) {
        this.race = WyHelper.getResourceName(value);
    }

    @Override
    public String getRace() {
        return this.race;
    }

    @Override
    public boolean isSwordsman() {
        if (WyHelper.isNullOrEmpty(this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("swordsman");
    }

    @Override
    public boolean isSniper() {
        if (WyHelper.isNullOrEmpty(this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("sniper");
    }

    @Override
    public boolean isDoctor() {
        if (WyHelper.isNullOrEmpty(this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("doctor");
    }

    @Override
    public boolean isWeatherWizard() {
        if (WyHelper.isNullOrEmpty(this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("art_of_weather");
    }

    @Override
    public boolean isBlackLeg() {
        if (WyHelper.isNullOrEmpty(this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("black_leg");
    }

    @Override
    public boolean isBrawler() {
        if (WyHelper.isNullOrEmpty(this.fightingStyle)) {
            return false;
        }
        return this.fightingStyle.equalsIgnoreCase("brawler");
    }

    @Override
    public boolean hasFightingStyle() {
        return !WyHelper.isNullOrEmpty(this.fightingStyle);
    }

    @Override
    public void setFightingStyle(String value) {
        this.fightingStyle = value;
    }

    @Override
    public String getFightingStyle() {
        return this.fightingStyle;
    }

    @Override
    public boolean hasShadow() {
        return this.hasShadow;
    }

    @Override
    public void setShadow(boolean value) {
        this.hasShadow = value;
    }

    @Override
    public boolean hasHeart() {
        return this.hasHeart;
    }

    @Override
    public void setHeart(boolean value) {
        this.hasHeart = value;
    }

    @Override
    public boolean isInCombatMode() {
        return this.inCombatMode;
    }

    @Override
    public void setCombatMode(boolean value) {
        this.inCombatMode = value;
    }

    @Override
    public boolean hasStrawDoll() {
        return this.hasStrawDoll;
    }

    @Override
    public void setStrawDoll(boolean value) {
        this.hasStrawDoll = value;
    }

    @Override
    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Override
    public void setDamageMultiplier(double multiplier) {
        this.damageMultiplier = multiplier;
    }

    @Override
    public boolean isBunnyMink() {
        return this.subRace.equalsIgnoreCase("mink_bunny");
    }

    @Override
    public boolean isDogMink() {
        return this.subRace.equalsIgnoreCase("mink_dog");
    }

    @Override
    public boolean isLionMink() {
        return this.subRace.equalsIgnoreCase("mink_lion");
    }

    @Override
    public void setSubRace(String value) {
        this.subRace = value;
    }

    @Override
    public String getSubRace() {
        return this.subRace;
    }
}

