/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtensibleEnum;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.IDynamicRenderer;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public abstract class OPEntity
extends CreatureEntity
implements IDynamicRenderer {
    protected String[] textures;
    protected boolean needsEntityDataUpdate;
    private static final DataParameter<String> TEXTURE = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> HAS_BUSOSHOKU_HAKI_ACTIVE = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> HAS_FULLBODY_HAKI_ACTIVE = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANIMATION = EntityDataManager.func_187226_a(OPEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final AttributeModifier GENERIC_BUSO_ATTACK_MULTIPLIER = new AttributeModifier(UUID.fromString("41120ad1-c457-44d5-ac4c-896e83e1333f"), "Generic Buso Haki Strength Multiplier", 0.5, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    private static final AttributeModifier FULLBODY_BUSO_ATTACK_MULTIPLIER = new AttributeModifier(UUID.fromString("5d4e0e3d-2580-47c0-bbcf-19c4ee04eb48"), "Fullbody Buso Haki Strength Multiplier", 0.4, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    private static final AttributeModifier FULLBODY_BUSO_DEFENSE_MULTIPLIER = new AttributeModifier(UUID.fromString("49252c18-dcd6-4b3f-9fbc-df1962f999ab"), "Fullbody Buso Haki Defense Multiplier", 0.4, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    private int doriki;
    private int belly;
    protected int threat;
    private Goal currentGoal;
    private Goal previousGoal;
    private boolean isFishman;

    public OPEntity(EntityType type, World world) {
        this(type, world, null);
    }

    public OPEntity(EntityType type, World world, String[] textures) {
        super(type, world);
        this.field_70728_aV = this.threat = 2;
        this.textures = textures;
        this.chooseTexture();
        this.isFishman = EntityStatsCapability.get((LivingEntity)this).isFishman();
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(TEXTURE, (Object)"");
        this.func_184212_Q().func_187214_a(ANIMATION, (Object)0);
        this.func_184212_Q().func_187214_a(HAS_BUSOSHOKU_HAKI_ACTIVE, (Object)false);
        this.func_184212_Q().func_187214_a(HAS_FULLBODY_HAKI_ACTIVE, (Object)false);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("doriki", this.doriki);
        nbt.func_74768_a("belly", this.belly);
        nbt.func_74768_a("threat", this.threat);
        nbt.func_74768_a("animation", this.getAnimation());
        nbt.func_74778_a("texture", this.getMobTexture());
        nbt.func_74757_a("hasBusoHaki", this.hasBusoHaki());
        nbt.func_74757_a("hasFullbodyHaki", this.hasFullbodyHaki());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.doriki = nbt.func_74762_e("doriki");
        this.belly = nbt.func_74762_e("belly");
        this.threat = nbt.func_74762_e("threat");
        this.setAnimation(nbt.func_74762_e("animation"));
        this.setTexture(nbt.func_74779_i("texture"));
        this.setBusoHaki(nbt.func_74767_n("hasBusoHaki"));
        this.setFullbodyHaki(nbt.func_74767_n("hasFullbodyHaki"));
    }

    @Override
    public String getDefaultTexture() {
        if (this.textures != null) {
            return this.textures[0];
        }
        return "null";
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_184641_n(false);
        if (WyHelper.isNullOrEmpty(this.getMobTexture())) {
            this.setTexture(this.getDefaultTexture());
        }
        return spawnData;
    }

    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        boolean flag1 = !world.func_180495_p(pos).isAir((IBlockReader)world, pos);
        boolean flag2 = pos.func_177956_o() < 150;
        boolean flag3 = block.getBlock() == Blocks.field_196658_i || block.getBlock() == Blocks.field_150354_m || block.getBlock() == Blocks.field_150348_b;
        float weight = 64 / pos.func_177956_o() * 10;
        return flag1 && flag2 && flag3 ? weight : 0.0f;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return this.func_205022_a(new BlockPos((Entity)this), (IWorldReader)world) > 0.0f;
    }

    public boolean func_213397_c(double distance) {
        return !this.func_145818_k_() || CommonConfig.INSTANCE.getDespawnWithNametag();
    }

    protected boolean shouldDrown() {
        return !this.isFishman;
    }

    @Override
    public String getMobTexture() {
        return (String)this.func_184212_Q().func_187225_a(TEXTURE);
    }

    protected void setTexture(String id) {
        this.func_184212_Q().func_187227_b(TEXTURE, (Object)id);
    }

    protected void chooseTexture() {
        if (this.textures != null && this.textures.length > 0) {
            int id = this.field_70146_Z.nextInt(this.textures.length);
            this.setTexture(this.textures[id]);
        }
    }

    public int getDoriki() {
        return this.doriki;
    }

    public void setDoriki(double value) {
        this.doriki = (int)Math.floor(value);
    }

    public int getBelly() {
        return this.belly;
    }

    public void setBelly(double value) {
        this.belly = (int)Math.floor(value);
    }

    public int getAnimation() {
        return (Integer)this.field_70180_af.func_187225_a(ANIMATION);
    }

    public void setAnimation(int value) {
        this.field_70180_af.func_187227_b(ANIMATION, (Object)value);
    }

    public boolean hasBusoHaki() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_BUSOSHOKU_HAKI_ACTIVE);
    }

    public void setBusoHaki(boolean value) {
        this.field_70180_af.func_187227_b(HAS_BUSOSHOKU_HAKI_ACTIVE, (Object)value);
    }

    public boolean hasFullbodyHaki() {
        return (Boolean)this.field_70180_af.func_187225_a(HAS_FULLBODY_HAKI_ACTIVE);
    }

    public void setFullbodyHaki(boolean value) {
        this.field_70180_af.func_187227_b(HAS_FULLBODY_HAKI_ACTIVE, (Object)value);
    }

    public Goal getCurrentGoal() {
        return this.currentGoal;
    }

    public Goal getPreviousGoal() {
        return this.previousGoal;
    }

    public void setCurrentGoal(Goal goal) {
        this.currentGoal = goal;
    }

    public void setPreviousGoal(Goal goal) {
        this.previousGoal = goal;
    }

    public void addThreat(int threat) {
        this.threat += threat;
    }

    public int getThreat() {
        return this.threat;
    }

    public void setThreat(int threat) {
        this.threat = threat;
    }

    public void queueEntityDataUpdate() {
        this.needsEntityDataUpdate = true;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.hasBusoHaki()) {
                if (!this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(GENERIC_BUSO_ATTACK_MULTIPLIER)) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(GENERIC_BUSO_ATTACK_MULTIPLIER);
                }
            } else if (this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(GENERIC_BUSO_ATTACK_MULTIPLIER)) {
                this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(GENERIC_BUSO_ATTACK_MULTIPLIER);
            }
            if (this.hasFullbodyHaki()) {
                if (!this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(FULLBODY_BUSO_ATTACK_MULTIPLIER)) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(FULLBODY_BUSO_ATTACK_MULTIPLIER);
                }
                if (!this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_180374_a(FULLBODY_BUSO_DEFENSE_MULTIPLIER)) {
                    this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(FULLBODY_BUSO_DEFENSE_MULTIPLIER);
                }
            } else {
                if (this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_180374_a(FULLBODY_BUSO_ATTACK_MULTIPLIER)) {
                    this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(FULLBODY_BUSO_ATTACK_MULTIPLIER);
                }
                if (this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_180374_a(FULLBODY_BUSO_DEFENSE_MULTIPLIER)) {
                    this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(FULLBODY_BUSO_DEFENSE_MULTIPLIER);
                }
            }
            if (this.func_184187_bx() instanceof BoatEntity && this.func_70638_az() != null) {
                this.func_184210_p();
            }
            if (this.needsEntityDataUpdate) {
                IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
                WyNetwork.sendToAllTrackingAndSelf(new SSyncEntityStatsPacket(this.func_145782_y(), props), (LivingEntity)this);
                this.needsEntityDataUpdate = false;
            }
        }
    }

    public static enum Animation implements IExtensibleEnum
    {
        NONE(0),
        FLINTLOCK_POINTING(1),
        CLEAVE_ATTACK(2),
        SHOCKWAVE(3),
        BLOCK(4);

        private int id;

        private Animation(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Animation create(String name, int id) {
            throw new IllegalStateException("Enum not extended");
        }
    }
}

