/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.TraderEntity;
import xyz.pixelatedw.mineminenomi.api.enums.Currency;
import xyz.pixelatedw.mineminenomi.api.helpers.CurrencyHelper;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModLootTables;
import xyz.pixelatedw.mineminenomi.packets.server.trade.SUpdateTraderOffersPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ui.SOpenTraderScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class SkypieanTraderEntity
extends TraderEntity {
    private static final String[] DEFAULT_TEXTURES = new String[]{"skypiean_trader1", "skypiean_trader2"};
    private int dirtTradesLeft = 120;

    public SkypieanTraderEntity(World world) {
        super(ModEntities.SKYPIEAN_TRADER, world, DEFAULT_TEXTURES);
        this.setCanBuyFromPlayers();
    }

    @Override
    public boolean canTrade(PlayerEntity player) {
        return true;
    }

    @Override
    public ResourceLocation getTradeTable() {
        return ModLootTables.SKYPIEAN_TRADER;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74768_a("tradesLeft", this.dirtTradesLeft);
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.dirtTradesLeft = nbt.func_74762_e("tradesLeft");
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K) {
            WyNetwork.sendTo(new SOpenTraderScreenPacket(this.func_145782_y()), player);
            WyNetwork.sendTo(new SUpdateTraderOffersPacket(this.func_145782_y(), this.tradeEntries, this.dirtTradesLeft), player);
            return true;
        }
        return false;
    }

    public void removeTradesLeft(int value) {
        this.dirtTradesLeft = this.dirtTradesLeft - value > 0 ? (this.dirtTradesLeft -= value) : 0;
    }

    public void setTradesLeft(int value) {
        this.dirtTradesLeft = value;
    }

    public int getTradesLeft() {
        return this.dirtTradesLeft;
    }

    public long getExtolLeftInStock() {
        return CurrencyHelper.getExtolFromBelly(this.dirtTradesLeft);
    }

    @Override
    public String getTradeFailMessage() {
        return "";
    }

    @Override
    public Currency getCurrency() {
        return Currency.EXTOL;
    }
}

