/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.ability;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.AbstractMarineEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BlackKnightEntity
extends OPEntity {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(BlackKnightEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    public boolean isAggressive = true;
    public List<LivingEntity> forcedTargets = new ArrayList<LivingEntity>();

    public BlackKnightEntity(World world) {
        super(ModEntities.BLACK_KNIGHT, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(200.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, null);
    }

    public boolean func_70097_a(DamageSource damageSource, float damageValue) {
        if (damageSource.func_76346_g() != null && damageSource.func_76346_g() instanceof PlayerEntity && damageSource.func_76346_g() == this.getOwner()) {
            return false;
        }
        return super.func_70097_a(damageSource, damageValue);
    }

    public boolean func_70652_k(Entity target) {
        boolean flag;
        float damage = (float)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        int knockback = 0;
        if (target instanceof LivingEntity) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.func_184614_ca(), (CreatureAttribute)((LivingEntity)target).func_70668_bt());
            knockback = (int)((float)knockback + (float)EnchantmentHelper.func_77501_a((LivingEntity)this));
        }
        if ((flag = target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), damage)) && knockback > 0) {
            target.func_70024_g((double)(-MathHelper.func_76126_a((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
            this.func_213317_d(this.func_213322_ci().func_216372_d(0.6, 1.0, 0.6));
        }
        return flag;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            PlayerEntity owner = this.getOwner();
            if (owner == null) {
                this.func_70106_y();
                return;
            }
            if (this.func_70032_d((Entity)owner) > 10.0f) {
                this.func_70661_as().func_75497_a((Entity)owner, 1.5);
            }
            if (this.func_70032_d((Entity)owner) > 80.0f) {
                this.func_70634_a(owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_());
            }
            IEntityStats ownerProps = EntityStatsCapability.get((LivingEntity)owner);
            IDevilFruit ownerDFProps = DevilFruitCapability.get((LivingEntity)owner);
            List<Object> targetsList = this.isAggressive ? WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, 10.0, PlayerEntity.class, AbstractMarineEntity.class, AbstractPirateEntity.class, MonsterEntity.class) : (!this.forcedTargets.isEmpty() ? this.forcedTargets : new ArrayList());
            LivingEntity target = null;
            if (!ownerDFProps.getDevilFruit().equalsIgnoreCase("ito_ito")) {
                this.func_70106_y();
            }
            if (!(targetsList.isEmpty() || this.func_70638_az() != null && this.func_70638_az().func_70089_S())) {
                if (targetsList.contains(owner)) {
                    targetsList.remove(owner);
                }
                if (ownerProps.isMarine()) {
                    targetsList = targetsList.stream().filter(x -> !(x instanceof AbstractMarineEntity)).collect(Collectors.toList());
                }
                target = targetsList.stream().findFirst().orElse(null);
            }
            if (target != null) {
                this.func_70624_b(target);
            }
            if (!this.forcedTargets.isEmpty()) {
                Iterator<LivingEntity> it = this.forcedTargets.iterator();
                while (it.hasNext()) {
                    LivingEntity forcedTarget = it.next();
                    if (forcedTarget != null && forcedTarget.func_70089_S()) continue;
                    it.remove();
                }
            }
        }
        super.func_70071_h_();
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    public void setOwner(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public PlayerEntity getOwner() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }
}

