/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class KungFuDugongEntity
extends AnimalEntity {
    private static final AttributeModifier RAGE_MODIFIER = new AttributeModifier(UUID.fromString("4b03a4b4-1eb5-464a-8312-0f9079044462"), "Rage Mode Multiplier", 10.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final Item[] FOOD = new Item[]{Items.field_151083_be, Items.field_151077_bg, Items.field_196102_ba, Items.field_179557_bn, Items.field_151157_am, Items.field_179559_bp, Items.field_196104_bb};
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(KungFuDugongEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_ENRAGED = EntityDataManager.func_187226_a(KungFuDugongEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_SITTING = EntityDataManager.func_187226_a(KungFuDugongEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_HAPPY = EntityDataManager.func_187226_a(KungFuDugongEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_TRAINING = EntityDataManager.func_187226_a(KungFuDugongEntity.class, (IDataSerializer)DataSerializers.field_187198_h);

    public KungFuDugongEntity(World world) {
        super(ModEntities.KUNG_FU_DUGONG, world);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(1, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, Optional.empty());
        this.func_184212_Q().func_187214_a(IS_ENRAGED, (Object)false);
        this.func_184212_Q().func_187214_a(IS_SITTING, (Object)false);
        this.func_184212_Q().func_187214_a(IS_HAPPY, (Object)false);
        this.func_184212_Q().func_187214_a(IS_TRAINING, (Object)false);
    }

    public void func_70636_d() {
        block12: {
            boolean flagHealth;
            super.func_70636_d();
            if (this.field_70170_p.field_72995_K) break block12;
            boolean flagOwnerNearby = this.getOwner() != null && this.func_70032_d((Entity)this.getOwner()) < 10.0f;
            boolean flagTamed = this.isTamed();
            boolean flagHasNoTarget = this.func_70638_az() == null;
            boolean flagSitting = flagHasNoTarget && this.isSitting();
            boolean bl = flagHealth = this.func_110143_aJ() > this.func_110138_aP() / 3.0f;
            if (flagOwnerNearby && flagTamed && flagSitting && flagHealth) {
                this.setHappy(true);
            } else {
                this.setHappy(false);
            }
            if (!flagHasNoTarget) {
                this.setHappy(false);
            }
            if (flagSitting || this.isTraining()) {
                this.func_70661_as().func_75499_g();
            }
            if (this.func_70638_az() == this.getOwner()) {
                this.func_70624_b(null);
                this.func_70604_c(null);
                this.func_70661_as().func_75499_g();
            }
            if (flagTamed) {
                if (flagSitting) {
                    List<PlayerEntity> players = WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, 3.0, PlayerEntity.class);
                    for (PlayerEntity player : players) {
                        if (player != this.getOwner()) continue;
                        this.func_200602_a(EntityAnchorArgument.Type.EYES, player.func_174824_e(0.0f));
                        this.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 40, 0, false, false));
                    }
                } else {
                    if (this.func_70032_d((Entity)this.getOwner()) > 10.0f) {
                        this.func_70661_as().func_75497_a((Entity)this.getOwner(), 1.5);
                    }
                    if (this.func_70032_d((Entity)this.getOwner()) > 80.0f) {
                        this.func_70634_a(this.getOwner().func_226277_ct_(), this.getOwner().func_226278_cu_(), this.getOwner().func_226281_cx_());
                    }
                    for (CreatureEntity target : WyHelper.getEntitiesNear(this.getOwner().func_180425_c(), this.field_70170_p, 40.0, CreatureEntity.class)) {
                        if (target == null || !target.func_70089_S() || target.func_70638_az() == null || !target.func_70638_az().equals((Object)this.getOwner())) continue;
                        this.func_70624_b((LivingEntity)target);
                    }
                }
            }
        }
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        super.func_70097_a(damageSource, amount);
        Entity entity = damageSource.func_76346_g();
        if (this.isTamed() && entity instanceof LivingEntity && entity != this.getOwner()) {
            this.func_70624_b((LivingEntity)entity);
        } else if (!this.isTamed() && !this.field_70170_p.field_72995_K && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (!player.func_184586_b(player.func_184600_cs()).func_190926_b()) {
                this.setEnraged(true);
                for (int i = 0; i < 5; ++i) {
                    double offsetX = this.field_70146_Z.nextGaussian() * 0.02;
                    double offsetY = this.field_70146_Z.nextGaussian() * 0.02;
                    double offsetZ = this.field_70146_Z.nextGaussian() * 0.02;
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197609_b, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.0 + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
            } else if (!this.isEnraged() && this.func_110143_aJ() < this.func_110138_aP() / 2.0f) {
                for (int i = 0; i < 5; ++i) {
                    double offsetX = this.field_70146_Z.nextGaussian() * 0.02;
                    double offsetY = this.field_70146_Z.nextGaussian() * 0.02;
                    double offsetZ = this.field_70146_Z.nextGaussian() * 0.02;
                    ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.0 + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                }
                this.setOwner(player.func_110124_au());
            }
        }
        return true;
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (this.isTamed() && player == this.getOwner() && !player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND);
            if (!stack.func_190926_b() && this.func_110143_aJ() < this.func_110138_aP()) {
                Optional<Item> food = Arrays.stream(FOOD).filter(x -> stack.func_77973_b() == x).findFirst();
                if (food.isPresent()) {
                    stack.func_190918_g(1);
                    this.func_70691_i(4.0f);
                    for (int i = 0; i < 5; ++i) {
                        double offsetX = this.field_70146_Z.nextGaussian() * 0.02;
                        double offsetY = this.field_70146_Z.nextGaussian() * 0.02;
                        double offsetZ = this.field_70146_Z.nextGaussian() * 0.02;
                        ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.0 + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                    return true;
                }
            } else if (stack.func_190926_b()) {
                this.setSiting(!this.isSitting());
                this.func_70624_b(null);
                return true;
            }
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (((Optional)this.field_70180_af.func_187225_a(OWNER)).isPresent()) {
            compound.func_74778_a("owner", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
        compound.func_74757_a("isEnraged", ((Boolean)this.field_70180_af.func_187225_a(IS_ENRAGED)).booleanValue());
        compound.func_74757_a("isSitting", ((Boolean)this.field_70180_af.func_187225_a(IS_SITTING)).booleanValue());
        compound.func_74757_a("isHappy", ((Boolean)this.field_70180_af.func_187225_a(IS_HAPPY)).booleanValue());
        compound.func_74757_a("isTraining", ((Boolean)this.field_70180_af.func_187225_a(IS_TRAINING)).booleanValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!WyHelper.isNullOrEmpty(compound.func_74779_i("owner"))) {
            this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("owner"))));
        }
        this.field_70180_af.func_187227_b(IS_ENRAGED, (Object)compound.func_74767_n("isEnraged"));
        this.field_70180_af.func_187227_b(IS_SITTING, (Object)compound.func_74767_n("isSitting"));
        this.field_70180_af.func_187227_b(IS_HAPPY, (Object)compound.func_74767_n("isHappy"));
        this.field_70180_af.func_187227_b(IS_TRAINING, (Object)compound.func_74767_n("isTraining"));
    }

    public boolean func_213397_c(double distance) {
        return !this.isTamed();
    }

    public boolean isTraining() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_TRAINING);
    }

    public void setTraining(boolean value) {
        this.field_70180_af.func_187227_b(IS_TRAINING, (Object)value);
    }

    public boolean isHappy() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_HAPPY);
    }

    public void setHappy(boolean value) {
        this.field_70180_af.func_187227_b(IS_HAPPY, (Object)value);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SITTING);
    }

    public void setSiting(boolean value) {
        this.field_70180_af.func_187227_b(IS_SITTING, (Object)value);
    }

    public boolean isEnraged() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_ENRAGED);
    }

    public void setEnraged(boolean value) {
        this.field_70180_af.func_187227_b(IS_ENRAGED, (Object)value);
        IAttributeInstance attr = this.func_110148_a(SharedMonsterAttributes.field_111264_e);
        attr.func_111124_b(RAGE_MODIFIER);
        if (value) {
            attr.func_111121_a(RAGE_MODIFIER);
        }
    }

    public void setOwner(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public PlayerEntity getOwner() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public boolean isTamed() {
        return this.getOwner() != null;
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }
}

