/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.donkrieg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.DonKriegEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.NormalBulletProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GunArrayGoal
extends CooldownGoal {
    private float animationTimer = 0.0f;
    private DonKriegEntity entity;

    public GunArrayGoal(DonKriegEntity entity, int timer, int random) {
        super(entity, timer, random);
        this.entity = entity;
    }

    @Override
    public boolean func_75250_a() {
        boolean hasMovementUnblocked;
        boolean shouldExecute = super.func_75250_a();
        boolean hasTarget = this.entity.func_70638_az() != null;
        boolean hasHighHP = this.entity.func_110143_aJ() > this.entity.func_110138_aP() / 2.0f;
        boolean canSeeTarget = hasTarget && this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az());
        boolean hasDifferentPhase = this.entity.getPreviousGoal() != this;
        boolean hasChance = Math.abs(WyHelper.randomDouble()) < 0.5;
        boolean bl = hasMovementUnblocked = !this.entity.func_70644_a(ModEffects.MOVEMENT_BLOCKED);
        if (shouldExecute && hasHighHP && canSeeTarget && hasDifferentPhase && hasChance && hasMovementUnblocked) {
            this.execute();
            return true;
        }
        return false;
    }

    @Override
    public void endCooldown() {
        super.endCooldown();
        this.entity.setCurrentGoal(null);
        this.entity.setPreviousGoal(this);
        this.animationTimer = 0.0f;
    }

    public void execute() {
        this.entity.setAnimation(120);
        this.animationTimer += 0.05f;
        if (this.entity.func_70638_az() == null) {
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
            this.entity.setAnimation(OPEntity.Animation.NONE.ordinal());
            return;
        }
        if (this.animationTimer >= 1.4f) {
            for (int i = 0; i < 6; ++i) {
                NormalBulletProjectile proj = new NormalBulletProjectile(this.entity.field_70170_p, (LivingEntity)this.entity);
                proj.setDamage(4.0f);
                LivingEntity target = this.entity.func_70638_az();
                double velX = target.func_226277_ct_() - this.entity.func_226277_ct_();
                double velY = target.func_174813_aQ().field_72338_b + (double)(target.func_213302_cg() / 3.0f) - proj.func_226278_cu_();
                double velZ = target.func_226281_cx_() - this.entity.func_226281_cx_();
                double x = MathHelper.func_76133_a((double)(velX * velX + velZ * velZ));
                proj.func_70186_c(velX, velY + x * (double)0.1f, velZ, 1.6f, 15 - this.entity.field_70170_p.func_175659_aa().func_151525_a() * 4);
                this.entity.field_70170_p.func_217376_c((Entity)proj);
            }
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
            this.entity.setAnimation(OPEntity.Animation.NONE.ordinal());
        }
    }
}

