/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiGoal;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.haki.HaoshokuHakiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class HaoshokuHakiGoal
extends CooldownGoal {
    public static final ParticleEffect PARTICLES_1 = new HaoshokuHakiParticleEffect(1);
    public static final ParticleEffect PARTICLES_2 = new HaoshokuHakiParticleEffect(2);
    public static final ParticleEffect PARTICLES_3 = new HaoshokuHakiParticleEffect(3);
    private OPEntity entity;
    private float hakiXP;

    public HaoshokuHakiGoal(OPEntity entity, float hxp) {
        super(entity, 120, entity.func_70681_au().nextInt(10));
        this.entity = entity;
        this.entity.addThreat(20);
        this.hakiXP = hxp;
    }

    @Override
    public void endCooldown() {
        super.endCooldown();
        this.entity.setCurrentGoal(null);
        this.entity.setPreviousGoal(this);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (this.entity.func_70638_az() == null) {
            return false;
        }
        if (!this.entity.func_70635_at().func_75522_a((Entity)this.entity.func_70638_az())) {
            return false;
        }
        if (this.entity.func_70032_d((Entity)this.entity.func_70638_az()) < 5.0f) {
            return false;
        }
        this.execute((LivingEntity)this.entity);
        return true;
    }

    private void execute(LivingEntity player) {
        IHakiData hakiProps = HakiDataCapability.get(player);
        hakiProps.alterHakiOveruse(400);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.HAKI_RELEASE_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        float haoLevel = this.hakiXP / 100.0f;
        int cooldown = 0;
        double radius = 0.0;
        int unconsciousTimer = 0;
        if (haoLevel < 1.0f) {
            radius = 10.0;
            unconsciousTimer = 0;
            cooldown = 120;
            PARTICLES_1.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else if (haoLevel >= 1.0f && (double)haoLevel < 2.5) {
            radius = 25.0;
            unconsciousTimer = 100;
            cooldown = 60;
            PARTICLES_2.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else if ((double)haoLevel >= 2.5) {
            radius = 40.0;
            unconsciousTimer = 200;
            cooldown = 60;
            PARTICLES_3.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, radius, FactionHelper.getOutsideGroupPredicate(player), LivingEntity.class);
        targets.remove(player);
        this.maxCooldown = cooldown;
        for (LivingEntity target : targets) {
            if (unconsciousTimer > 0) {
                float targetHaoLevel = 0.0f;
                if (target instanceof PlayerEntity) {
                    targetHaoLevel = HakiHelper.getTotalHakiExp(target) / 100.0f;
                } else if (target instanceof OPEntity) {
                    float busoHaki = ((OPEntity)target).field_70714_bg.func_220888_c().anyMatch(goal -> goal.func_220772_j() instanceof BusoshokuHakiGoal) ? 1.0f : 0.0f;
                    float dorikiConversion = ((OPEntity)target).getDoriki() / 100;
                    targetHaoLevel = busoHaki + dorikiConversion;
                }
                if ((double)targetHaoLevel + 0.3 >= (double)haoLevel) continue;
                EffectInstance instance = new EffectInstance(ModEffects.UNCONSCIOUS, unconsciousTimer, 1, false, false);
                target.func_195064_c(new EffectInstance(ModEffects.ABILITY_OFF, unconsciousTimer - 20, 1, false, false));
                target.func_195064_c(instance);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), instance));
                continue;
            }
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 0));
        }
    }
}

