/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates;

import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.ai.IBrawler;
import xyz.pixelatedw.mineminenomi.api.entities.ai.IHakiUser;
import xyz.pixelatedw.mineminenomi.api.entities.ai.IRokushikiUser;
import xyz.pixelatedw.mineminenomi.api.entities.ai.ISwordsman;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.GapCloserGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PirateCaptainEntity
extends AbstractPirateEntity
implements IRokushikiUser,
ISwordsman,
IBrawler,
IHakiUser {
    private static final String[] DEFAULT_TEXTURES = new String[]{"pirate_captain1", "pirate_captain2", "pirate_captain3", "pirate_captain4", "pirate_captain5"};

    public PirateCaptainEntity(World world) {
        super((EntityType<? extends MobEntity>)ModEntities.PIRATE_CAPTAIN, world, DEFAULT_TEXTURES);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new GapCloserGoal(this));
        this.addRokushikiAbilities(this, 2);
        this.addSwordsmanAbilities(this, 2);
        this.addBrawlerAbilities(this, 3);
        this.addBusoshokuHaki(this, 30);
        this.setDoriki(20.0 + WyHelper.randomWithRange(0, 10) + (double)this.getThreat());
        this.setBelly(30.0 + WyHelper.randomWithRange(0, 20));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(WyHelper.randomWithRange(12, 15));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (this.field_70146_Z.nextDouble() < 0.4) {
            ItemStack capeStack = new ItemStack((IItemProvider)ModArmors.PIRATE_CAPTAIN_CAPE);
            this.func_184201_a(EquipmentSlotType.CHEST, capeStack);
        }
        if (this.field_70146_Z.nextDouble() < 0.8) {
            ItemStack randomSword = new ItemStack((IItemProvider)PIRATE_SWORDS[this.field_70146_Z.nextInt(PIRATE_SWORDS.length)]);
            this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
            if (this.field_70146_Z.nextDouble() < 0.2) {
                this.func_184201_a(EquipmentSlotType.OFFHAND, randomSword);
            }
        }
        if (this.field_70146_Z.nextDouble() < 0.7) {
            if (this.field_70146_Z.nextDouble() < 0.3) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.CIGAR));
            } else {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.CIGAR_LESS));
            }
        }
        return spawnData;
    }
}

