/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.BossInfo;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.CleaveAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.donkrieg.BakudanGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.donkrieg.DaisensoGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.donkrieg.GunArrayGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.donkrieg.MH5Goal;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.kriegpirates.AbstractKriegPirateEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class DonKriegEntity
extends AbstractKriegPirateEntity {
    private ServerBossInfo bossInfo = null;
    private static final DataParameter<Boolean> DAISENSO_PHASE = EntityDataManager.func_187226_a(DonKriegEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> MH5_PHASE = EntityDataManager.func_187226_a(DonKriegEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    public CleaveAttackGoal fistCleaveAttack;
    public BlockPos challengeSpawnPosition;
    public static final String ANIM_GUN_ARRAY_NAME = "GUN_ARRAY";
    public static final int ANIM_GUN_ARRAY_ID = 120;
    public static final String ANIM_MH5_NAME = "MH5";
    public static final int ANIM_MH5_ID = 121;

    public DonKriegEntity(World world) {
        super((EntityType<? extends MobEntity>)ModEntities.DON_KRIEG, world);
        this.setCrew("Krieg Pirates");
        OPEntity.Animation.create(ANIM_GUN_ARRAY_NAME, 120);
        OPEntity.Animation.create(ANIM_MH5_NAME, 121);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DAISENSO_PHASE, (Object)false);
        this.func_184212_Q().func_187214_a(MH5_PHASE, (Object)false);
    }

    @Override
    protected void func_184651_r() {
        this.fistCleaveAttack = new CleaveAttackGoal(this, 80, 4, 6).setAnimationId(OPEntity.Animation.CLEAVE_ATTACK.ordinal());
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.field_70714_bg.func_75776_a(1, (Goal)this.fistCleaveAttack);
        this.field_70714_bg.func_75776_a(2, (Goal)new GunArrayGoal(this, (int)WyHelper.randomWithRange(60, 80), 10));
        this.field_70714_bg.func_75776_a(2, (Goal)new BakudanGoal(this, (int)WyHelper.randomWithRange(120, 140), 10));
        this.field_70714_bg.func_75776_a(3, (Goal)new DaisensoGoal(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new MH5Goal(this));
        this.setDoriki(100.0 + WyHelper.randomWithRange(0, 20) + (double)this.getThreat());
        this.setBelly(20.0 + WyHelper.randomWithRange(0, 5));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(60.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.22f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(0.8);
        this.func_110148_a(SharedMonsterAttributes.field_221120_g).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(20.0);
        this.func_110148_a(ModAttributes.ATTACK_RANGE).func_111128_a(1.5);
    }

    @Override
    public void func_70071_h_() {
        if (this.bossInfo != null) {
            this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        }
        super.func_70071_h_();
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186760_a(player);
        }
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186761_b(player);
        }
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_184201_a(EquipmentSlotType.CHEST, new ItemStack((IItemProvider)ModArmors.WOOTZ_STEEL_ARMOR));
        if (reason == SpawnReason.EVENT) {
            this.bossInfo = (ServerBossInfo)new ServerBossInfo(this.func_145748_c_(), BossInfo.Color.RED, BossInfo.Overlay.PROGRESS).func_186741_a(false);
        }
        return spawnData;
    }

    @Override
    public boolean func_213397_c(double distance) {
        return false;
    }

    public boolean isDaisensoActive() {
        return (Boolean)this.field_70180_af.func_187225_a(DAISENSO_PHASE);
    }

    public boolean isMH5Active() {
        return (Boolean)this.field_70180_af.func_187225_a(MH5_PHASE);
    }

    public void triggerDaisensoPhase() {
        this.field_70180_af.func_187227_b(DAISENSO_PHASE, (Object)true);
    }

    public void triggerMH5Phase() {
        this.field_70180_af.func_187227_b(MH5_PHASE, (Object)true);
    }
}

