/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.entities.ai.IHakiUser;
import xyz.pixelatedw.mineminenomi.api.entities.ai.ISwordsman;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.entities.mobs.bandits.AbstractBanditEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.pirates.AbstractPirateEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.quest.givers.IHakiTrainer;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SwordsmanTrainerEntity
extends TrainerEntity
implements IHakiTrainer,
IHakiUser,
ISwordsman {
    private static final String[] DEFAULT_TEXTURES = new String[]{"dojosensei1", "dojosensei2", "dojosensei3"};
    protected Item[] swords = new Item[]{ModWeapons.SANDAI_KITETSU, ModWeapons.NIDAI_KITESTU, ModWeapons.WADO_ICHIMONJI, Items.field_151048_u};

    public SwordsmanTrainerEntity(World world) {
        super(ModEntities.SWORDSMAN_TRAINER, world, DEFAULT_TEXTURES);
    }

    @Override
    public void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, true));
        this.field_70714_bg.func_75776_a(3, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractPirateEntity.class, true));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractBanditEntity.class, true));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.addSwordsmanAbilities(this, 4);
        this.addBusoshokuHaki(this, 100);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.2f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(80.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.setDoriki(20.0 + WyHelper.randomWithRange(0, 10) + (double)this.getThreat());
        this.setBelly(20.0 + WyHelper.randomWithRange(0, 20));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        return true;
    }

    @Override
    protected void func_213333_a(DamageSource source, int looting, boolean recentlyHitIn) {
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        ItemStack randomSword = new ItemStack((IItemProvider)this.swords[this.field_70146_Z.nextInt(this.swords.length)]);
        randomSword.func_196082_o().func_74757_a("isClone", true);
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
        return spawnData;
    }

    @Override
    public Quest[] getAvailableQuests(PlayerEntity player) {
        IEntityStats entityProps = EntityStatsCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        ArrayList<Quest> availableQuests = new ArrayList<Quest>();
        if (entityProps.isSwordsman()) {
            availableQuests.addAll(Arrays.asList(ModQuests.SWORDSMAN_TRIALS));
        }
        Quest[] quests = new Quest[availableQuests.size()];
        return availableQuests.toArray(quests);
    }

    @Override
    public HakiType getTrainingHaki() {
        return HakiType.IMBUING;
    }
}

