/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.projectiles.artofweather.ArtOfWeatherProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class GustSwordProjectile
extends AbilityProjectileEntity {
    public GustSwordProjectile(World world) {
        super(ArtOfWeatherProjectiles.GUST_SWORD, world);
    }

    public GustSwordProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GustSwordProjectile(World world, double x, double y, double z) {
        super(ArtOfWeatherProjectiles.GUST_SWORD, world, x, y, z);
    }

    public GustSwordProjectile(World world, LivingEntity player) {
        super(ArtOfWeatherProjectiles.GUST_SWORD, world, player);
        this.setDamage(2.0f);
        this.setPhysical(false);
        this.onTickEvent = this::onTickEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        Vec3d speed = WyHelper.propulsion(this.func_85052_h(), 4.0, 4.0);
        hitEntity.func_70097_a(this.source, 15.0f);
        hitEntity.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
        hitEntity.field_70133_I = true;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 3.0;
                double offsetY = WyHelper.randomDouble() / 3.0;
                double offsetZ = WyHelper.randomDouble() / 3.0;
                ParticleType<GenericParticleData> particle = i % 2 == 0 ? ModParticleTypes.MOKU : ModParticleTypes.MOKU2;
                GenericParticleData data = new GenericParticleData(particle);
                data.setLife(10);
                data.setSize(1.5f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

