/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.awa;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.projectiles.awa.AwaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class RelaxHourProjectile
extends AbilityProjectileEntity {
    public RelaxHourProjectile(World world) {
        super(AwaProjectiles.RELAX_HOUR, world);
    }

    public RelaxHourProjectile(EntityType type, World world) {
        super(type, world);
    }

    public RelaxHourProjectile(World world, double x, double y, double z) {
        super(AwaProjectiles.RELAX_HOUR, world, x, y, z);
    }

    public RelaxHourProjectile(World world, LivingEntity player) {
        super(AwaProjectiles.RELAX_HOUR, world, player);
        this.setDamage(3.0f);
        this.setMaxLife(40);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setChangeHurtTime(true);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_195064_c(new EffectInstance(ModEffects.WASHED, 200, 0));
        this.onBlockImpactEvent.onImpact(hitEntity.func_180425_c());
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 15; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                ParticleType<GenericParticleData> particle = ModParticleTypes.AWA;
                if (i % 3 == 0) {
                    particle = ModParticleTypes.AWA3;
                }
                GenericParticleData data = new GenericParticleData(particle);
                data.setLife(7);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 5; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.AWA_FOAM);
                data.setLife(7);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

