/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.beta;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.beta.BetaProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class StickyProjectile
extends AbilityProjectileEntity {
    private boolean causeExplosion = false;

    public StickyProjectile(World world) {
        super(BetaProjectiles.STICKY_PROJECTILE, world);
    }

    public StickyProjectile(EntityType type, World world) {
        super(type, world);
    }

    public StickyProjectile(World world, double x, double y, double z) {
        super(BetaProjectiles.STICKY_PROJECTILE, world, x, y, z);
    }

    public StickyProjectile(World world, LivingEntity player) {
        super(BetaProjectiles.STICKY_PROJECTILE, world, player);
        this.setDamage(2.0f);
        this.setMaxLife(20);
        this.setGravity(0.025f);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            GenericParticleData data;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 4; ++i) {
                offsetX = WyHelper.randomDouble() / 5.0;
                offsetY = WyHelper.randomDouble() / 5.0;
                offsetZ = WyHelper.randomDouble() / 5.0;
                data = new GenericParticleData(ModParticleTypes.BETA);
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.25 + offsetY, this.func_226281_cx_() + offsetZ);
            }
            if (this.causeExplosion) {
                for (i = 0; i < 2; ++i) {
                    offsetX = WyHelper.randomDouble() / 2.0;
                    offsetY = WyHelper.randomDouble() / 2.0;
                    offsetZ = WyHelper.randomDouble() / 2.0;
                    data = new GenericParticleData(ModParticleTypes.MERA);
                    data.setLife(7);
                    data.setSize(1.2f);
                    WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
                }
            }
        }
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        if (this.causeExplosion) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 2.0f);
            explosion.setStaticDamage(10.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.setDamageEntities(true);
            explosion.doExplosion();
        } else {
            entity.func_195064_c(new EffectInstance(ModEffects.STICKY, 300, 0, false, false));
            for (int i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomWithRange(-2, 2);
                double offsetZ = WyHelper.randomWithRange(-2, 2);
                BlockPos location = new BlockPos(this.func_226277_ct_() + offsetX, this.func_226278_cu_() - 1.0, this.func_226281_cx_() + offsetZ);
                if (!this.field_70170_p.func_180495_p(location.func_177977_b()).func_200132_m()) continue;
                AbilityHelper.placeBlockIfAllowed(this.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), ModBlocks.MUCUS, DefaultProtectionRules.AIR_FOLIAGE);
            }
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        if (this.causeExplosion) {
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 2.0f);
            explosion.setStaticDamage(10.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(false);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(true);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.setDamageEntities(true);
            explosion.doExplosion();
        } else {
            for (int i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomWithRange(-2, 2);
                double offsetZ = WyHelper.randomWithRange(-2, 2);
                BlockPos location = new BlockPos(this.func_226277_ct_() + offsetX, this.func_226278_cu_(), this.func_226281_cx_() + offsetZ);
                if (!this.field_70170_p.func_180495_p(location.func_177977_b()).func_200132_m()) continue;
                AbilityHelper.placeBlockIfAllowed(this.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), ModBlocks.MUCUS, DefaultProtectionRules.AIR_FOLIAGE);
            }
        }
    }

    public void setCauseExplosion() {
        this.causeExplosion = true;
    }
}

