/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.CyborgProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class RadicalBeamProjectile
extends AbilityProjectileEntity {
    public RadicalBeamProjectile(World world) {
        super(CyborgProjectiles.RADICAL_BEAM, world);
    }

    public RadicalBeamProjectile(EntityType type, World world) {
        super(type, world);
    }

    public RadicalBeamProjectile(World world, double x, double y, double z) {
        super(CyborgProjectiles.RADICAL_BEAM, world, x, y, z);
    }

    public RadicalBeamProjectile(World world, LivingEntity player) {
        super(CyborgProjectiles.RADICAL_BEAM, world, player);
        this.setDamage(30.0f);
        this.setArmorPiercing();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 4.0f);
        explosion.setStaticDamage(25.0f);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(3));
        explosion.doExplosion();
    }
}

