/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.extra;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.ExtraProjectiles;
import xyz.pixelatedw.mineminenomi.particles.effects.common.ShockwaveParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class ShockwaveProjectile
extends AbilityProjectileEntity {
    private static final ShockwaveParticleEffect PARTICLES = new ShockwaveParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE);
    private boolean canBreakBlocks = false;

    public ShockwaveProjectile(World world) {
        super(ExtraProjectiles.SHOCKWAVE, world);
    }

    public ShockwaveProjectile(EntityType type, World world) {
        super(type, world);
    }

    public ShockwaveProjectile(World world, double x, double y, double z) {
        super(ExtraProjectiles.SHOCKWAVE, world, x, y, z);
    }

    public ShockwaveProjectile(World world, LivingEntity entity) {
        this(world, entity, false);
    }

    public ShockwaveProjectile(World world, LivingEntity entity, boolean canBreakBlocks) {
        super(ExtraProjectiles.SHOCKWAVE, world, entity);
        this.setDamage(8.0f);
        this.setCollisionSize(2.0);
        this.setPhysical(false);
        this.setMaxLife(10);
        this.setPassThroughEntities();
        this.onTickEvent = this::onTickEvent;
        this.canBreakBlocks = canBreakBlocks;
    }

    private void onTickEvent() {
        BlockPos pos = null;
        int j = 1;
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_180425_c().func_177979_c(j);
                break;
            }
            if (j > 5) break;
            ++j;
        }
        if (pos == null) {
            return;
        }
        if (this.canBreakBlocks) {
            AbilityHelper.createFilledSphere(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 1, Blocks.field_150350_a, GRIEF_RULE);
        }
        PARTICLES.spawn(this.field_70170_p, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), 0.0, 0.0, 0.0);
    }
}

