/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gasu;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.GasuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class GasRobeProjectile
extends AbilityProjectileEntity {
    public GasRobeProjectile(World world) {
        super(GasuProjectiles.GAS_ROBE, world);
    }

    public GasRobeProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GasRobeProjectile(World world, double x, double y, double z) {
        super(GasuProjectiles.GAS_ROBE, world, x, y, z);
    }

    public GasRobeProjectile(World world, LivingEntity player) {
        super(GasuProjectiles.GAS_ROBE, world, player);
        this.setDamage(0.1f);
        this.setMaxLife(30);
        this.setPassThroughEntities();
        this.setChangeHurtTime(true);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76437_t, 200, 2), new EffectInstance(Effects.field_76440_q, 40, 0), new EffectInstance(Effects.field_76436_u, 200, 6)};
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = WyHelper.randomDouble() / 3.0;
                double offsetY = WyHelper.randomDouble() / 3.0;
                double offsetZ = WyHelper.randomDouble() / 3.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.GASU);
                data.setLife(5);
                data.setSize(2.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

