/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gasu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gasu.GasuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class GastilleProjectile
extends AbilityProjectileEntity {
    public GastilleProjectile(World world) {
        super(GasuProjectiles.GASTILLE, world);
    }

    public GastilleProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GastilleProjectile(World world, double x, double y, double z) {
        super(GasuProjectiles.GASTILLE, world, x, y, z);
    }

    public GastilleProjectile(World world, LivingEntity player) {
        super(GasuProjectiles.GASTILLE, world, player);
        this.setDamage(30.0f);
        this.setDamageSource(DamageSource.field_76372_a);
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(Effects.field_76436_u, 200, 3)};
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 5.0f);
        explosion.setStaticDamage(28.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(5));
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 2; ++i) {
                double offsetX = WyHelper.randomDouble() / 5.0;
                double offsetY = WyHelper.randomDouble() / 5.0;
                double offsetZ = WyHelper.randomDouble() / 5.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.GASU2);
                data.setLife(5);
                data.setSize(0.8f);
                data.setColor(0.4f, 0.7f, 1.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

