/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goro;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.KairosekiBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.RestrictedBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.LightningExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class LightningEntity
extends Entity {
    protected static final DataParameter<Float> LENGTH = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Float> DAMAGE = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> BRANCHES = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> SEGMENTS = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> ALIVE_TICKS = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> ANGLE = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> MIMIC_VANILLA = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> LIGHTNING_MOVEMENT = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> ENERGY_EFFECT = EntityDataManager.func_187226_a(LightningEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private final LightningBoltEntity bolt;
    public long seed;
    private List<Entity> entities;
    private List<BlockPos> contactBlocks;
    public List<BlockPos> firstContactBlocks;
    public List<Integer> targets;
    private Entity thrower;
    private int explosionSize;
    private float explosionBlockResistance;
    private int heightDifference;
    private boolean explosionDestroysBlocks;
    private boolean firstTick;
    private boolean hasToCheckForTarget;
    private boolean canCauseKnockback;
    private double boxSizeDivision;
    private int targetTimeToReset;
    private float travelSpeed;
    private float travelLength;
    DamageSource source;
    private BlockPos finalPos;

    public LightningEntity(EntityType<LightningEntity> entityType, World world) {
        super(entityType, world);
        this.bolt = new LightningBoltEntity(this.field_70170_p, 0.0, 0.0, 0.0, false);
        this.entities = new ArrayList<Entity>();
        this.contactBlocks = new ArrayList<BlockPos>();
        this.firstContactBlocks = new ArrayList<BlockPos>();
        this.targets = new ArrayList<Integer>();
        this.explosionSize = 0;
        this.explosionBlockResistance = 0.1f;
        this.heightDifference = 0;
        this.explosionDestroysBlocks = true;
        this.firstTick = true;
        this.hasToCheckForTarget = true;
        this.canCauseKnockback = true;
        this.boxSizeDivision = 0.1;
        this.targetTimeToReset = 20;
        this.travelSpeed = 12.0f;
        this.travelLength = 0.0f;
        this.field_70158_ak = true;
        this.seed = this.field_70146_Z.nextLong();
        this.entities = new ArrayList<Entity>();
        this.firstContactBlocks = new ArrayList<BlockPos>();
        this.contactBlocks = new ArrayList<BlockPos>();
        this.targets = new ArrayList<Integer>();
    }

    public LightningEntity(Entity thrower, float travelLength) {
        this(thrower, thrower.func_226277_ct_(), thrower.func_226280_cw_(), thrower.func_226281_cx_(), thrower.field_70177_z, thrower.field_70125_A, travelLength, travelLength);
    }

    public LightningEntity(Entity thrower, float travelLength, float travelSpeed) {
        this(thrower, thrower.func_226277_ct_(), thrower.func_226280_cw_(), thrower.func_226281_cx_(), thrower.field_70177_z, thrower.field_70125_A, travelLength, travelSpeed);
    }

    public LightningEntity(Entity thrower, double posX, double posY, double posZ, float rotationYaw, float rotationPitch, float travelLength, float travelSpeed) {
        this(GoroProjectiles.LIGHTNING, thrower.field_70170_p);
        this.func_70012_b(posX, posY, posZ, rotationYaw, rotationPitch);
        this.setLength(2.0f);
        this.thrower = thrower;
        this.travelLength = travelLength;
        this.travelSpeed = travelSpeed;
        this.source = new IndirectEntityDamageSource(ModDamageSource.LIGHTNING_BOLT.func_76355_l(), (Entity)this, this.thrower).func_76348_h();
    }

    public LightningEntity(World worldIn) {
        super(GoroProjectiles.LIGHTNING, worldIn);
        this.bolt = new LightningBoltEntity(this.field_70170_p, 0.0, 0.0, 0.0, false);
        this.entities = new ArrayList<Entity>();
        this.contactBlocks = new ArrayList<BlockPos>();
        this.firstContactBlocks = new ArrayList<BlockPos>();
        this.targets = new ArrayList<Integer>();
        this.explosionSize = 0;
        this.explosionBlockResistance = 0.1f;
        this.heightDifference = 0;
        this.explosionDestroysBlocks = true;
        this.firstTick = true;
        this.hasToCheckForTarget = true;
        this.canCauseKnockback = true;
        this.boxSizeDivision = 0.1;
        this.targetTimeToReset = 20;
        this.travelSpeed = 12.0f;
        this.travelLength = 0.0f;
    }

    public void onEntityImpactEvent(Entity hitEntity) {
        if (this.targets.contains(hitEntity.getEntity().func_145782_y()) || hitEntity.func_145782_y() == this.func_145782_y()) {
            return;
        }
        if (this.hasToCheckForTarget) {
            this.targets.add(hitEntity.getEntity().func_145782_y());
        }
        if (this.getDamage() > 0.0f) {
            if (hitEntity.func_70089_S() && hitEntity instanceof LivingEntity) {
                if (this.getMimicVanilla()) {
                    hitEntity.func_70015_d(2 + (int)((float)(this.func_223314_ad() / 20) + this.getDamage() / 5.0f));
                    hitEntity.func_70077_a(this.bolt);
                }
                hitEntity.field_70172_ad = 0;
                ((LivingEntity)hitEntity).field_70737_aN = 0;
                hitEntity.func_70097_a(this.source, this.getDamage());
                this.onFirstImpact(hitEntity.func_180425_c());
            }
            if (hitEntity instanceof ThrowableEntity) {
                if (hitEntity instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)hitEntity).source.func_76355_l().equals("lightningBolt")) {
                    return;
                }
                hitEntity.func_70106_y();
            }
        }
    }

    public void onBlockImpact(BlockPos hit) {
        if (this.heightDifference > 0 && this.thrower.func_226278_cu_() - (double)this.heightDifference > (double)hit.func_177956_o()) {
            return;
        }
        Block block = this.field_70170_p.func_180495_p(hit).func_177230_c();
        boolean blockIsKairoseki = KairosekiBlockProtectionRule.INSTANCE.isBanned(block);
        boolean blockIsRestricted = RestrictedBlockProtectionRule.INSTANCE.isBanned(block);
        if (!blockIsKairoseki && !blockIsRestricted && this.explosionDestroysBlocks) {
            this.field_70170_p.func_217377_a(hit, false);
        }
    }

    public void onFirstImpact(BlockPos hit) {
        ExplosionAbility explosion = AbilityHelper.newExplosion(this, this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), this.explosionSize);
        explosion.setExplosionSound(false);
        if (!this.canCauseKnockback) {
            explosion.disableExplosionKnockback();
        }
        explosion.setStaticDamage(this.getDamage() / 2.0f);
        explosion.func_199592_a(this.source);
        explosion.setDamageOwner(false);
        explosion.setStaticBlockResistance(this.explosionBlockResistance);
        explosion.setDestroyBlocks(this.explosionDestroysBlocks);
        explosion.setHeightDifference(this.heightDifference);
        explosion.setFireAfterExplosion(true);
        explosion.setAlwaysDamage(true);
        explosion.setSmokeParticles(new LightningExplosionParticleEffect(this.explosionSize + 1));
        explosion.setExplosionSound(false);
        explosion.setDamageEntities(true);
        explosion.doExplosion();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa >= this.getAliveTicks()) {
            this.func_70106_y();
        }
        if (this.getLightningMovement()) {
            this.seed = this.field_70146_Z.nextLong();
        }
        if (!this.field_70170_p.field_72995_K) {
            boolean addedTick = false;
            if (this.getLength() != this.travelLength) {
                this.setAliveTicks(this.getAliveTicks() + 1);
                this.setLength(Math.min(this.getLength() + this.travelSpeed, this.travelLength));
                this.firstTick = true;
                addedTick = true;
            }
            if (this.field_70173_aa % this.targetTimeToReset == 0 && this.hasToCheckForTarget && !addedTick) {
                this.targets.clear();
            }
            this.entities.clear();
            this.contactBlocks.clear();
            boolean canExplode = this.explosionSize > 0 && CommonConfig.INSTANCE.isAbilityGriefingEnabled();
            Vec3d vec3d = this.func_70040_Z();
            int i = 0;
            while ((float)i < this.getLength()) {
                double currentX = this.func_226277_ct_() + vec3d.field_72450_a * (double)i;
                double currentY = this.func_226280_cw_() + vec3d.field_72448_b * (double)i;
                double currentZ = this.func_226281_cx_() + vec3d.field_72449_c * (double)i;
                double boxSize = 0.2 + (double)this.getSize() / this.boxSizeDivision;
                AxisAlignedBB alignedBB = new AxisAlignedBB(currentX - boxSize, currentY - boxSize, currentZ - boxSize, currentX + boxSize, currentY + boxSize, currentZ + boxSize);
                this.field_70170_p.func_72839_b(this.thrower, alignedBB).stream().filter(e -> !this.entities.contains(e)).forEach(this.entities::add);
                if (canExplode || !this.getMimicVanilla()) {
                    BlockPos currentBlockPos = new BlockPos(currentX, currentY, currentZ);
                    for (double x = alignedBB.field_72340_a; x < alignedBB.field_72336_d; x += 1.0) {
                        for (double y = alignedBB.field_72338_b; y < alignedBB.field_72337_e; y += 1.0) {
                            for (double z = alignedBB.field_72339_c; z < alignedBB.field_72334_f; z += 1.0) {
                                BlockPos blockPos = new BlockPos(x, y, z);
                                BlockState state = this.field_70170_p.func_180495_p(blockPos);
                                if (state.isAir((IBlockReader)this.field_70170_p, blockPos) || this.contactBlocks.contains(blockPos) || blockPos.equals((Object)currentBlockPos)) continue;
                                this.contactBlocks.add(blockPos);
                            }
                        }
                    }
                    if (this.firstTick && !this.field_70170_p.func_180495_p(currentBlockPos).isAir((IBlockReader)this.field_70170_p, currentBlockPos) && !this.firstContactBlocks.contains(currentBlockPos)) {
                        this.firstContactBlocks.add(currentBlockPos);
                    }
                    if ((float)i == this.getLength()) {
                        this.finalPos = currentBlockPos;
                    }
                }
                ++i;
            }
            this.entities.forEach(this::onEntityImpactEvent);
            if ((this.field_70173_aa % 5 == 0 || this.firstTick) && canExplode) {
                if (this.firstTick) {
                    this.firstContactBlocks.forEach(this::onFirstImpact);
                } else {
                    this.contactBlocks.forEach(this::onBlockImpact);
                }
                if (this.getDamage() > 12.0f) {
                    WorldInfo info = this.field_70170_p.func_72912_H();
                    if (this.finalPos != null && (float)this.finalPos.func_177956_o() > info.func_76067_t().getCloudHeight()) {
                        info.func_76069_a(true);
                    }
                }
            }
        }
        if (this.firstTick && this.getLength() == this.travelLength) {
            this.firstTick = false;
        } else if (this.getMimicVanilla()) {
            this.field_70170_p.func_225605_c_(4);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * LightningEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(LENGTH, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(BRANCHES, (Object)5);
        this.field_70180_af.func_187214_a(ANGLE, (Object)50);
        this.field_70180_af.func_187214_a(SEGMENTS, (Object)7);
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.01f));
        this.field_70180_af.func_187214_a(DAMAGE, (Object)Float.valueOf(10.0f));
        this.field_70180_af.func_187214_a(ALIVE_TICKS, (Object)10);
        this.field_70180_af.func_187214_a(COLOR, (Object)641023);
        this.field_70180_af.func_187214_a(MIMIC_VANILLA, (Object)true);
        this.field_70180_af.func_187214_a(LIGHTNING_MOVEMENT, (Object)true);
        this.field_70180_af.func_187214_a(ENERGY_EFFECT, (Object)true);
    }

    public void setExplosion(int range) {
        this.explosionSize = range;
    }

    public void setExplosion(int range, boolean destroysBlocks) {
        this.explosionSize = range;
        this.explosionDestroysBlocks = destroysBlocks;
    }

    public void setExplosion(int range, boolean destroysBlocks, float explosionBlockResistance) {
        this.explosionSize = range;
        this.explosionDestroysBlocks = destroysBlocks;
        this.explosionBlockResistance = explosionBlockResistance;
    }

    public void setExplosion(int range, boolean destroysBlocks, float explosionBlockResistance, int heightLimit) {
        this.explosionSize = range;
        this.explosionDestroysBlocks = destroysBlocks;
        this.explosionBlockResistance = explosionBlockResistance;
        this.heightDifference = heightLimit;
    }

    public void setTargetTimeToReset(int value) {
        this.targetTimeToReset = value;
    }

    public void disableExplosionKnockback() {
        this.canCauseKnockback = false;
    }

    public int getAliveTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ALIVE_TICKS);
    }

    public void setAliveTicks(int ticks) {
        this.field_70180_af.func_187227_b(ALIVE_TICKS, (Object)ticks);
    }

    public float getDamage() {
        return ((Float)this.field_70180_af.func_187225_a(DAMAGE)).floatValue();
    }

    public void setDamage(float damage) {
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(damage));
    }

    public float getLength() {
        return ((Float)this.field_70180_af.func_187225_a(LENGTH)).floatValue();
    }

    public void setLength(float length) {
        this.field_70180_af.func_187227_b(LENGTH, (Object)Float.valueOf(length));
    }

    public void disableLightningMimic() {
        this.field_70180_af.func_187227_b(MIMIC_VANILLA, (Object)false);
    }

    public void disableLightningMovement() {
        this.field_70180_af.func_187227_b(LIGHTNING_MOVEMENT, (Object)false);
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public boolean getMimicVanilla() {
        return (Boolean)this.field_70180_af.func_187225_a(MIMIC_VANILLA);
    }

    public boolean getLightningMovement() {
        return (Boolean)this.field_70180_af.func_187225_a(LIGHTNING_MOVEMENT);
    }

    public void setColor(Color color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color.getRGB());
    }

    public int getBranches() {
        return (Integer)this.field_70180_af.func_187225_a(BRANCHES);
    }

    public void setBranches(int branches) {
        this.field_70180_af.func_187227_b(BRANCHES, (Object)branches);
    }

    public int getSegments() {
        return (Integer)this.field_70180_af.func_187225_a(SEGMENTS);
    }

    public void setSegments(int segments) {
        this.field_70180_af.func_187227_b(SEGMENTS, (Object)segments);
    }

    public int getAngle() {
        return (Integer)this.field_70180_af.func_187225_a(ANGLE);
    }

    public void setAngle(int angle) {
        this.field_70180_af.func_187227_b(BRANCHES, (Object)Math.round(WyHelper.clamp(angle, 0L, 180L)));
    }

    public void setBoxSizeDivision(double value) {
        this.boxSizeDivision = value;
    }

    public void disableEnergyEffect() {
        this.field_70180_af.func_187227_b(ENERGY_EFFECT, (Object)false);
    }

    public boolean getEnergyEffect() {
        return (Boolean)this.field_70180_af.func_187225_a(ENERGY_EFFECT);
    }

    public void func_70037_a(CompoundNBT compound) {
        compound.func_74768_a("alive_ticks", this.getAliveTicks());
        compound.func_74776_a("damage", this.getDamage());
    }

    public void func_213281_b(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(ALIVE_TICKS, (Object)compound.func_74762_e("alive_ticks"));
        this.field_70180_af.func_187227_b(DAMAGE, (Object)Float.valueOf(compound.func_74760_g("damage")));
    }
}

