/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class RaigoProjectile
extends AbilityProjectileEntity {
    private boolean explodedOnBlock = false;
    private boolean dealtAOE = false;
    boolean closeToFloor = false;

    public RaigoProjectile(World world) {
        super(GoroProjectiles.RAIGO, world);
    }

    public RaigoProjectile(EntityType type, World world) {
        super(type, world);
    }

    public RaigoProjectile(World world, double x, double y, double z) {
        super(GoroProjectiles.RAIGO, world, x, y, z);
    }

    public RaigoProjectile(World world, LivingEntity player) {
        super(GoroProjectiles.RAIGO, world, player);
        this.setDamage(120.0f);
        this.setMaxLife(256);
        this.setCollisionSize(8.0);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        this.setTargetResetTime(120);
        this.setDamageSource(ModDamageSource.LIGHTNING_BOLT.causeIndirectDamageFromSource(this));
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        ExplosionAbility explosion;
        if (!this.field_70170_p.func_180495_p(hit).isAir((IBlockReader)this.field_70170_p, hit)) {
            if (!this.explodedOnBlock) {
                explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 40.0f);
                explosion.setStaticDamage(0.0f);
                explosion.setStaticBlockResistance(0.1f);
                explosion.setFireAfterExplosion(true);
                explosion.func_199592_a(ModDamageSource.LIGHTNING_BOLT.causeIndirectDamageFromSource(this));
                explosion.setSmokeParticles(new CommonExplosionParticleEffect(40));
                explosion.doExplosion();
            }
            this.explodedOnBlock = true;
        } else {
            explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 40.0f);
            explosion.setStaticDamage(0.0f);
            explosion.setStaticBlockResistance(0.1f);
            explosion.setFireAfterExplosion(true);
            explosion.setAlwaysDamage(true);
            explosion.func_199592_a(ModDamageSource.LIGHTNING_BOLT.causeIndirectDamageFromSource(this));
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(40));
            explosion.doExplosion();
        }
        if (!this.dealtAOE) {
            List<Entity> list = WyHelper.getEntitiesNear(this.func_180425_c(), this.field_70170_p, 50.0, Entity.class);
            list.remove(this.func_85052_h());
            for (Entity target : list) {
                if (target instanceof ThrowableEntity || target instanceof AbstractArrowEntity) {
                    target.func_70106_y();
                }
                if (!(target instanceof LivingEntity)) continue;
                target.field_70172_ad = 0;
                ((LivingEntity)target).field_70737_aN = 0;
                target.func_70097_a(ModDamageSource.LIGHTNING_BOLT.causeEntityDamageFromSource((Entity)this.func_85052_h()), 120.0f);
                Vec3d speed = target.func_70676_i(1.0f).func_216372_d(-1.0, -1.0, -1.0).func_216372_d(5.0, 0.0, 5.0);
                target.func_213293_j(speed.field_72450_a, 1.0, speed.field_72449_c);
                target.field_70133_I = true;
            }
            this.dealtAOE = true;
        }
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            BlockRayTraceResult mop;
            for (int i = 0; i < 25; ++i) {
                ParticleType<GenericParticleData> particleToUse = this.field_70173_aa % 2 == 0 ? ModParticleTypes.GORO2 : ModParticleTypes.GORO;
                double offsetX = WyHelper.randomDouble() * 5.0;
                double offsetY = WyHelper.randomDouble();
                double offsetZ = WyHelper.randomDouble() * 5.0;
                GenericParticleData data = new GenericParticleData(particleToUse);
                data.setLife(20);
                data.setSize(7.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            this.func_70101_b(0.0f, 90.0f);
            if (!this.closeToFloor && (mop = WyHelper.rayTraceBlocks((Entity)this, 30.0)).func_216346_c().equals((Object)RayTraceResult.Type.BLOCK)) {
                this.setMaxLife(16);
                this.closeToFloor = true;
            }
            if (this.field_70173_aa % 5 == 0) {
                for (int j = 0; j < 50; ++j) {
                    float boltLength = (float)WyHelper.randomWithRange(36, 50);
                    LightningEntity bolt = new LightningEntity((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (float)WyHelper.randomWithRange(0, 360), (float)WyHelper.randomWithRange(-90, 90), boltLength, boltLength);
                    bolt.setAngle(20);
                    bolt.setAliveTicks(20);
                    bolt.setDamage(0.0f);
                    bolt.setExplosion(0, false);
                    bolt.setSize(boltLength / 800.0f);
                    bolt.setBranches(3);
                    bolt.setSegments(10);
                    this.field_70170_p.func_217376_c((Entity)bolt);
                }
            }
        }
    }
}

