/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.goro;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.IFlexibleSizeProjectile;

public class VoltVariProjectile
extends AbilityProjectileEntity
implements IFlexibleSizeProjectile {
    private static final int maxDamage = 100;
    List<Integer> hitList = new ArrayList<Integer>();

    public VoltVariProjectile(World world) {
        super(GoroProjectiles.VOLT_VARI, world);
    }

    public VoltVariProjectile(EntityType type, World world) {
        super(type, world);
    }

    public VoltVariProjectile(World world, double x, double y, double z) {
        super(GoroProjectiles.VOLT_VARI, world, x, y, z);
    }

    public VoltVariProjectile(World world, LivingEntity player) {
        super(GoroProjectiles.VOLT_VARI, world, player);
        this.setDamage(100.0f);
        this.setDamageSource(ModDamageSource.LIGHTNING_BOLT.causeIndirectDamageFromSource(this));
        this.onTickEvent = this::onTickEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    private void onBlockImpactEvent(BlockPos hit) {
        float power = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() / 10.0f;
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), power);
        explosion.setStaticDamage(power * 7.5f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setStaticBlockResistance(0.1f);
        explosion.setFireAfterExplosion(true);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)(power * 0.9f)));
        explosion.setDamageEntities(true);
        explosion.func_199592_a(ModDamageSource.LIGHTNING_BOLT.causeIndirectDamageFromSource(this));
        explosion.doExplosion();
    }

    private void onTickEvent() {
        float voltage = ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                ParticleType<GenericParticleData> particleToUse = this.field_70173_aa % 2 == 0 ? ModParticleTypes.GORO2 : ModParticleTypes.GORO;
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(particleToUse);
                data.setLife(8);
                data.setSize(4.0f * voltage / 100.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            if (this.func_85052_h() == null) {
                return;
            }
            List list = WyHelper.getEntitiesNearSphere(this.func_180425_c(), this.field_70170_p, 2.0f + voltage / 10.0f, FactionHelper.getOutsideGroupPredicate(this.func_85052_h()), LivingEntity.class);
            list.stream().filter(e -> e.func_70685_l((Entity)this) && !this.hitList.contains(e.func_145782_y()) && e.func_145782_y() != this.func_85052_h().func_145782_y()).forEach(e -> {
                float distance = (float)Math.sqrt(this.func_70068_e((Entity)e));
                if (distance > 0.0f) {
                    this.hitList.add(e.func_145782_y());
                    LightningEntity bolt = new LightningEntity((Entity)this, 9.0f + distance);
                    bolt.func_200602_a(EntityAnchorArgument.Type.EYES, e.func_213303_ch());
                    bolt.setAliveTicks(8);
                    bolt.setDamage(voltage / 20.0f);
                    if (voltage > 10.0f) {
                        bolt.setExplosion(voltage > 60.0f ? (int)(voltage / 30.0f) : 1);
                    }
                    bolt.setBranches(5);
                    bolt.setSize(0.04f * (voltage / 100.0f));
                    this.field_70170_p.func_217376_c((Entity)bolt);
                }
            });
            if (this.field_70173_aa % 10 == 0) {
                this.hitList.clear();
            }
        }
    }

    @Override
    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
    }

    @Override
    public void increaseSize() {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(Math.min(((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() + 1.0f, 100.0f)));
    }

    @Override
    public void setSize(float size) {
        this.setDamage(20.0f + 100.0f * (size / 100.0f));
        this.func_174826_a(this.func_174813_aQ().func_186662_g((double)(size / 100.0f)));
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(Math.min(size, 100.0f)));
    }

    @Override
    public float getSize() {
        return 0.7f + ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue() / 10.0f;
    }
}

