/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class IceBlockPartisanProjectile
extends AbilityProjectileEntity {
    public IceBlockPartisanProjectile(World world) {
        super(HieProjectiles.ICE_BLOCK_PARTISAN, world);
    }

    public IceBlockPartisanProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBlockPartisanProjectile(World world, double x, double y, double z) {
        super(HieProjectiles.ICE_BLOCK_PARTISAN, world, x, y, z);
    }

    public IceBlockPartisanProjectile(World world, LivingEntity player) {
        super(HieProjectiles.ICE_BLOCK_PARTISAN, world, player);
        this.setDamage(5.0f);
        this.setMaxLife(40);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.setChangeHurtTime(true);
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        AbilityHelper.addFrostbite(entity, this.func_85052_h(), 50);
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), Blocks.field_205164_gk, DefaultProtectionRules.CORE_FOLIAGE_ORE_LIQUID);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.HIE);
                data.setLife(2);
                data.setSize(1.5f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

